% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.synonyms.R
\name{get.synonyms}
\alias{get.synonyms}
\title{get.synonyms()}
\usage{
get.synonyms(ramclustObj = NULL, get.db = TRUE, update.names = TRUE,
  lipid.short.hand = TRUE)
}
\arguments{
\item{ramclustObj}{R object - the ramclustR object which was used to write the .mat or .msp files}

\item{get.db}{logical - should the HMDB, LipidMaps, CheBI, and Pubchem names be retreived when available?}

\item{update.names}{logical - should the ramclustObj$ann slot (annotation) be updated based on the above? selection of which synonym to chose is difficult to automate well - new name may not be the most commonly used.}

\item{lipid.short.hand}{- logical - should the stringr pacakge be used to look for lipid short hand nomenclature in the synonyms? Only used when update.names = TRUE}
}
\value{
an updated ramclustR object, with the RC$synonyms slot containing a list with length equal to the number of compounds in the dataset.  Each list element represents a character vector of all the synonyms returns (or NA, for compounds with no inchikey)
}
\description{
Use chemical translation service to retreive synonyms for ramclustR inchikeys
}
\details{
this function uses the chemical translation service (http://cts.fiehnlab.ucdavis.edu/), HMDB, LipidMaps, and PubChem databases to retreive synonymns and compound names ror a given inchikey).  Lipid shorthand (i.e. PC(36:6)) can be identified and used when available.  Precendence for naming is lipid.short.hand > HMDB > LipidMaps > Pubchem > original assignment.
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

http://cts.fiehnlab.ucdavis.edu/static/download/CTS2-MS2015.pdf
}
\author{
Corey Broeckling
}
\keyword{'MSFinder',}
\keyword{'RAMClustR',}
\keyword{'chemical}
\keyword{'clustering',}
\keyword{'cts'}
\keyword{'feature',}
\keyword{'mass}
\keyword{'metabolomics',}
\keyword{'ramclustR'}
\keyword{'ramclustR',}
\keyword{'xcms',}
\keyword{service',}
\keyword{spectrometry',}
\keyword{translation}
