% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_RGWAS.R
\name{calcGRM}
\alias{calcGRM}
\title{Function to calculate genomic relationship matrix (GRM)}
\usage{
calcGRM(
  genoMat,
  methodGRM = "addNOIA",
  subpop = NULL,
  kernel.h = "tuned",
  returnWMat = FALSE,
  probaa = NULL,
  probAa = NULL
)
}
\arguments{
\item{genoMat}{A \eqn{N \times M} matrix of marker genotype}

\item{methodGRM}{Method to calculate genomic relationship matrix (GRM). We offer the following methods;
"addNOIA", "domNOIA", "A.mat", "linear", "gaussian", "exponential", "correlation".
For NOIA methods, please refer to Vitezica et al. 2017.}

\item{subpop}{Sub-population names corresponding to each individual.
By utilizing `subpop` argument, you can consider the difference of allele frequencies
between sub-populations when computing the genomic relationship matrix. This argument is only valid when NOIA methods are selected.}

\item{kernel.h}{The hyper parameter for gaussian or exponential kernel.
If kernel.h = "tuned", this hyper parameter is calculated as the median of off-diagonals of distance matrix of genotype data.}

\item{returnWMat}{If this argument is TRUE, we will return W matrix instead of GRM.
Here, W satisfies \eqn{GRM = W W ^ {T}}. W corresponds to H matix in Vitezica et al. 2017.}

\item{probaa}{Probability of being homozygous for the reference allele for each marker.
If NULL (default), it will be calculated from genoMat.}

\item{probAa}{Probability of being heterozygous for the reference and alternative alleles for each marker
If NULL (default), it will be calculated from genoMat.}
}
\value{
genomic relationship matrix (GRM)
}
\description{
Function to calculate genomic relationship matrix (GRM)
}
\references{
Vitezica, Z.G., Legarra, A., Toro, M.A. and Varona, L. (2017) Orthogonal Estimates of Variances for Additive, Dominance, and Epistatic Effects in Populations. Genetics. 206(3): 1297-1307.

Endelman, J.B. and Jannink, J.L. (2012) Shrinkage Estimation of the Realized Relationship Matrix. G3 Genes, Genomes, Genet. 2(11): 1405-1413.
}
