% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMM_functions_cpp.R
\name{spectralG.cpp}
\alias{spectralG.cpp}
\title{Perform spectral decomposition (inplemented by Rcpp)}
\usage{
spectralG.cpp(
  ZETA,
  ZWs = NULL,
  X = NULL,
  weights = 1,
  return.G = TRUE,
  return.SGS = FALSE,
  spectral.method = NULL,
  tol = NULL,
  df.H = NULL
)
}
\arguments{
\item{ZETA}{A list of variance (relationship) matrix (K; \eqn{m \times m}) and its design matrix (Z; \eqn{n \times m}) of random effects. You can use only one kernel matrix.
For example, ZETA = list(A = list(Z = Z, K = K))
Please set names of list "Z" and "K"!}

\item{ZWs}{A list of additional linear kernels other than genomic relationship matrix (GRM).
We utilize this argument in RGWAS.multisnp function, so you can ignore this.}

\item{X}{\eqn{n \times p} matrix. You should assign mean vector (rep(1, n)) and covariates. NA is not allowed.}

\item{weights}{If the length of ZETA >= 2, you should assign the ratio of variance components to this argument.}

\item{return.G}{If thie argument is TRUE, spectral decomposition results of G will be returned.
(\eqn{G = ZKZ'})}

\item{return.SGS}{If this argument is TRUE, spectral decomposition results of SGS will be returned.
(\eqn{S = I - X(X'X)^{-1}X}, \eqn{G = ZKZ'})}

\item{spectral.method}{The method of spectral decomposition.
In this function, "eigen" : eigen decomposition and "cholesky" : cholesky and singular value decomposition are offered.
If this argument is NULL, either method will be chosen accorsing to the dimension of Z and X.}

\item{tol}{The tolerance for detecting linear dependencies in the columns of G = ZKZ'.
Eigen vectors whose eigen values are less than "tol" argument will be omitted from results.
If tol is NULL, top 'n' eigen values will be effective.}

\item{df.H}{The degree of freedom of K matrix. If this argument is NULL, min(n, sum(nrow(K1), nrow(K2), ...)) will be assigned.}
}
\value{
\describe{
\item{$spectral.G}{The spectral decomposition results of G.}
\item{$U}{Eigen vectors of G.}
\item{$delta}{Eigen values of G.}
\item{$spectral.SGS}{Estimator for \eqn{\sigma^2_e}}
\item{$Q}{Eigen vectors of SGS.}
\item{$theta}{Eigen values of SGS.}
}
}
\description{
Perform spectral decomposition for \eqn{G = ZKZ'} or \eqn{SGS} where \eqn{S = I - X(X'X)^{-1}X}.
}
