% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{fl.report}
\alias{fl.report}
\title{Create a PDF and HTML report with results from a fluorescence analysis workflow}
\usage{
fl.report(
  flFitRes,
  out.dir = tempdir(),
  out.nm = NULL,
  ec50 = FALSE,
  format = c("pdf", "html"),
  export = FALSE,
  parallelize = TRUE,
  ...
)
}
\arguments{
\item{flFitRes}{A \code{grofit} object created with \code{\link{fl.workflow}}.}

\item{out.dir}{(Character) The path or name of the folder in which the report files are created.  If \code{NULL}, the folder will be named with a combination of 'Report.fluorescence_' and the current date and time.}

\item{out.nm}{{Character or \code{NULL}} Define the name of the report files. If \code{NULL}, the files will be named with a combination of 'FluorescenceReport_' and the current date and time.}

\item{ec50}{(Logical) Display results of dose-response analysis (\code{TRUE}) or not (\code{FALSE}).}

\item{format}{(Character) Define the file format for the report, PDF (\code{'pdf'}) and/or HTML (\code{'html'}). Default: (\code{c('pdf', 'html')})}

\item{export}{(Logical) Shall all plots generated in the report be exported as individual PDF and PNG files \code{TRUE} or not \code{FALSE}?}

\item{parallelize}{(Logical) Create plots using all but one available processor cores (\code{TRUE}) or only a single core (\code{FALSE}).}

\item{...}{Further arguments passed to create a report. Currently required:
\itemize{
\item \code{mean.grp}: Define groups to combine into common plots in the report based on sample identifiers. Partial matches with sample/group names are accepted. Can be \code{'all'}, a vector of strings, or a list of string vectors. Note: The maximum number of sample groups (with unique condition/concentration indicators) is 50. If you have more than 50 groups, option \code{'all'} will produce the error \code{! Insufficient values in manual scale. [Number] needed but only 50 provided}.
\item \code{mean.conc}: Define concentrations to combine into common plots in the  report. Can be a numeric vector, or a list of numeric vectors.
}}
}
\value{
\code{NULL}
}
\description{
\code{fl.report} requires a \code{flFitRes} object and creates a report in PDF and HTML format that summarizes all results obtained.
}
\details{
The template .Rmd file used within this function can be found within the QurvE package installation directory.
}
\examples{
# load example dataset
\dontrun{
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Run workflow
res <- fl.workflow(grodata = input, ec50 = FALSE, fit.opt = 's',
                   x_type = 'time', norm_fl = TRUE,
                   dr.parameter = 'max_slope.spline',
                   suppress.messages = TRUE,
                   parallelize = FALSE)

fl.report(res, out.dir = tempdir(), parallelize = FALSE)
}
}
