% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_parsers.R
\name{parse_Gen5Gen6}
\alias{parse_Gen5Gen6}
\title{Extract relevant data from a raw data export file generated with the "Gen5" or "Gen6" software.}
\usage{
parse_Gen5Gen6(input)
}
\arguments{
\item{input}{A dataframe created by reading a table file with \code{\link{read_file}}}
}
\value{
a list of length two containing growth and/or fluorescence dataframes in the first and second element, respectively. The first column in these dataframes represents a time vector.
}
\description{
Extract relevant data from a raw data export file generated with the "Gen5" or "Gen6" software.
}
\examples{
if(interactive()){
input <- read_file(filename = system.file("fluorescence_test_Gen5.xlsx", package = "QurvE") )
parsed <- parse_Gen5Gen6(input)
}
}
