% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metrics.R
\name{SimilarityMetrics}
\alias{SimilarityMetrics}
\alias{DoNotConflict}
\alias{ExplicitlyAgree}
\alias{StrictJointAssertions}
\alias{SemiStrictJointAssertions}
\alias{SymmetricDifference}
\alias{RobinsonFoulds}
\alias{MarczewskiSteinhaus}
\alias{SteelPenny}
\alias{QuartetDivergence}
\title{Tree Similarity Metrics}
\usage{
SimilarityMetrics(elementStatus, similarity = TRUE)

DoNotConflict(elementStatus, similarity = TRUE)

ExplicitlyAgree(elementStatus, similarity = TRUE)

StrictJointAssertions(elementStatus, similarity = TRUE)

SemiStrictJointAssertions(elementStatus, similarity = TRUE)

SymmetricDifference(elementStatus, similarity = TRUE)

RobinsonFoulds(elementStatus, similarity = FALSE)

MarczewskiSteinhaus(elementStatus, similarity = TRUE)

SteelPenny(elementStatus, similarity = TRUE)

QuartetDivergence(elementStatus, similarity = TRUE)
}
\arguments{
\item{elementStatus}{Two-dimensional integer array, with rows corresponding to
counts of matching quartets or partitions for each tree, and columns named
according to the output of \code{[QuartetStatus]} or
\code{[SplitStatus]}.}

\item{similarity}{Logical specifying whether to calculate the similarity
or dissimilarity.}
}
\value{
\code{SimilarityMetrics} returns a named two-dimensional array in which each row
corresponds to an input tree, and each column corresponds to one of the
listed measures.

\code{DoNotConflict} and others return a named vector describing the requested
similarity (or difference) between the trees.
}
\description{
Functions to calculate tree similarity / difference metrics.
}
\details{
Estabrook \emph{et al.} (1985, table 2) define four similarity metrics in terms of the
total number of quartets (\emph{N}, their \emph{Q}), the number of quartets resolved in the same
manner in two trees (\emph{s}), the number resolved differently in both trees
(\emph{d}), the number resolved in tree 1 or 2 but unresolved in the other tree
(\emph{r1}, \emph{r2}), and the number that are unresolved in both trees (\emph{u}).

The similarity metrics are then given as below.  The dissimilarity metrics
are their complement (i.e. 1 - \emph{similarity}), and can be calculated
algebraically using the identity \emph{N} = \emph{s} + \emph{d} + \emph{r1} + \emph{r2} + \emph{u}.

Although defined using quartets, analogous values can be calculated using partitions
-- though for a number of reasons, quartets may offer a more meaningful
measure of the amount of information shared by two trees.
\itemize{
\item Do Not Conflict (DC): (\emph{s} + \emph{r1} + \emph{r2} + \emph{u}) / \emph{N}
\item Explicitly Agree (EA): \emph{s} / \emph{N}
\item Strict Joint Assertions (SJA): \emph{s} / (\emph{s} + \emph{d})
\item SemiStrict Joint Assertions (SSJA): \emph{s} / (\emph{s} + \emph{d} + \emph{u})
}

(The numerator of the SemiStrict Joint Assertions similarity metric is given in
Estabrook \emph{et al}. (1985)'s table 2 as \emph{s} + \emph{d}, but this is understood, with
reference to the text to be a typographic error.)

Steel & Penny (1993) propose a further metric, which they denote d<sub>Q</sub>,
which this package calculates using the function \code{SteelPenny}:
\itemize{
\item Steel & Penny's Quartet Metric (dQ): (\emph{s} + \emph{u}) / \emph{N}
}

Another take on tree similarity is to consider the symmetric difference: that is,
the number of partitions or quartets present in one tree that do not appear in the
other, originally used to measure tree similarity by Robinson & Foulds (1981).
(Note that, given the familiarity of the Robinson Foulds distance metric, this
quantity is be default expressed as a difference rather than a similarity.)
\itemize{
\item Robinson Foulds (RF): \emph{d1} + \emph{d2} + \emph{r1} + \emph{r2}
}

To contextualize the symmetric difference, it may be normalized against:

The total number of resolved quartets or partitions present in both trees (Day 1986):
\itemize{
\item Symmetric Difference (SD): (2 \emph{d} + \emph{r1} + \emph{r2}) / (2 \emph{d} + 2 \emph{s} + \emph{r1} + \emph{r2})
}

The total distinctly resolved quartets or partitions (Day 1986):
\itemize{
\item Marczewski-Steinhaus (MS): (2 \emph{d} + \emph{r1} + \emph{r2}) / (2 \emph{d} + \emph{s} + \emph{r1} + \emph{r2})
}

The maximum number of quartets or partitions that could have been resolved, given the
number of tips (Smith 2019):
\itemize{
\item Symmetric Divergence: (\emph{d} + \emph{d} + \emph{r1} + \emph{r2}) / 2 \emph{Q}
}
}
\examples{
  data('sq_trees')
  
  sq_status <- QuartetStatus(sq_trees)
  SimilarityMetrics(sq_status)
  QuartetDivergence(sq_status, similarity=FALSE)

}
\references{
\insertRef{Day1986}{Quartet}

\insertRef{Estabrook1985}{Quartet}

\insertRef{Marczewski1958}{Quartet}

\insertRef{Robinson1981}{Quartet}

\insertRef{Smith2019}{Quartet}

\insertRef{Steel1993}{Quartet}

\insertRef{Smith2019}{Quartet}
}
\seealso{
\itemize{
\item \code{\link[=QuartetStatus]{QuartetStatus()}}: Calculate status of each quartet: the raw material
from which the Estabrook \emph{et al.} metrics are calculated.
\item \code{\link[=SplitStatus]{SplitStatus()}}, \code{\link[=CompareSplits]{CompareSplits()}}: equivalent metrics for bipartition splits.
}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
