% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetDistance.R
\name{CompareQuartets}
\alias{CompareQuartets}
\title{Compare quartet states by explicit enumeration}
\usage{
CompareQuartets(x, cf)
}
\arguments{
\item{x, cf}{List of quartet states, perhaps generated by
\code{\link{QuartetStates}}.}
}
\value{
Returns an array of seven numeric elements, corresponding to the quantities of Estabrook \emph{et al}. (1985):
\describe{
\item{N}{The total number of quartet \emph{statements} for two trees of \emph{n} tips,
i.e. 2 \emph{Q}.}
\item{Q}{The total number of quartets for \emph{n} tips.}
\item{s}{The number of quartets that are resolved identically in both trees.}
\item{d}{The number of quartets that are resolved differently in each tree.}
\item{r1}{The number of quartets that are resolved in tree 1, but not in tree 2.}
\item{r2}{The number of quartets that are resolved in tree 2, but not in tree 1.}
\item{u}{The number of quartets that are unresolved in both trees.}
}
}
\description{
Uses explicit enumeration to compare two lists of quartet states,
detailing how many are identical and how many are unresolved.
For most purposes, the faster function \code{\link{QuartetStatus}} will be preferable.
}
\examples{
  n_tip <- 6
  trees <- list(ape::rtree(n_tip, tip.label=seq_len(n_tip), br=NULL),
                ape::rtree(n_tip, tip.label=seq_len(n_tip), br=NULL))
  splits <- lapply(trees, TreeSearch::Tree2Splits)
  quartets <- QuartetStates(splits)
  CompareQuartets(quartets[[1]], quartets[[2]])

}
\references{
{
\insertRef{Estabrook1985}{Quartet}
}
}
\seealso{
\code{\link{QuartetStatus}}, generates this output from a list of
trees.

Other element-by-element comparisons: \code{\link{CompareSplits}},
  \code{\link{PairSharedQuartetStatus}},
  \code{\link{QuartetState}},
  \code{\link{SharedQuartetStatus}},
  \code{\link{SplitStatus}}
}
\author{
Martin R. Smith
}
\concept{element-by-element comparisons}
