% Generated by roxygen2 (4.0.1): do not edit by hand
\name{QuantifQuantile}
\alias{QuantifQuantile}
\title{QuantifQuantile for X univariate}
\usage{
QuantifQuantile(X, Y, alpha = c(0.05, 0.25, 0.5, 0.75, 0.95),
  x = seq(min(X), max(X), length = 100), testN = c(35, 40, 45, 50, 55),
  p = 2, B = 50, tildeB = 20, same_N = TRUE)
}
\arguments{
\item{X}{vector of covariates.}

\item{Y}{vector of response variables.}

\item{alpha}{vector of order of the quantiles.}

\item{x}{vector of values for \code{x} in q_alpha(x).}

\item{testN}{grid of values of \code{N} that will be tested.}

\item{p}{L_p norm optimal quantization.}

\item{B}{number of bootstrap replications for the bootstrap estimator.}

\item{tildeB}{number of bootstrap replications for the choice of \code{N}.}

\item{same_N}{whether to use the same value of \code{N} for each \code{alpha}
(\code{TRUE} by default).}
}
\value{
An object of class \code{QuantifQuantile} which is a list with the
following components:

\item{hatq_opt}{A matrix containing the estimated conditional
quantiles. The number of columns is the number of considered values for \code{X}
 and the number of rows the size of the order vector \code{alpha}.}

\item{N_opt}{Optimal selected value for \code{N}. An integer if
\code{same_N}=TRUE and a vector of integers of length \code{length(alpha)}
otherwise.}

\item{hatMSE_N}{The matrix of estimated MSE provided by our selection
criterion for \code{N}. The number of columns is then \code{length(testN)}
and the number of rows \code{length(alpha)}.}

\item{hatq_N}{A 3-dimensional array containing the estimated
conditional quantiles for each considered value for \code{N}.}

\item{X}{The vector of covariates.}

\item{Y}{The vector of response variables.}

\item{x}{The considered vector of values for x in q_alpha(x).}

\item{alpha}{The considered vector of order for the quantiles.}

\item{testN}{The considered grid of values for \code{N} that were
tested.}
}
\description{
Estimation of conditional quantiles using optimal quantization
when \code{X} is univariate.
}
\details{
\itemize{\item This function calculates estimated conditional
quantiles with a method based on optimal quantization when the covariate is
unvariate. For multivariate covariate, see \code{\link{QuantifQuantile.d2}}
or \code{\link{QuantifQuantile.d}}.
\item The criterion for selecting the number of quantizers is implemented in
this function. The user has to choose a grid \code{testN} of possible values
in which \code{N} will be selected. It actually minimizes some bootstrap
estimated version of the MSE (Mean Squared Error). More precisely, for
\code{N} fixed, it calculates the sum according to \code{alpha} of
\code{hatMSE_N} and then minimizes the resulting vector to get \code{N_opt}.
 However, the user can choose to select a different value of \code{N_opt} for
 each \code{alpha} by setting \code{same_N=FALSE}. In this case, the vector
 \code{N_opt} is obtained by minimizing each column of \code{hatME_N}
 separately. The reason why \code{same_N=TRUE} by default is that taking
 \code{N_opt} according to \code{alpha} could provide crossing condtional
 quantile curves (rarely observed for not too close values of \code{alpha}.
 The function \code{\link{plot.select.N.QuantifQuantile}}
 illustrates the selection of \code{N_opt}. If the graph is not globally convex, the arguments
 \code{testN} should be adapted.}
}
\examples{
set.seed(644936)
n <- 300
X <- runif(300,-2,2)
Y <- X^2+rnorm(n)
res <- QuantifQuantile(X,Y,testN=seq(10,30,by=5))
res2 <- QuantifQuantile(X,Y,testN=seq(10,30,by=5),same_N=FALSE)
}
\references{
Charlier, I. and Paindaveine, D. and Saracco, J. (2014),
\emph{Conditional quantiles estimation through optimal quantization},
Submitted.

Charlier, I. and Paindaveine, D. and Saracco, J. (2014),
\emph{Numerical study of a conditional quantile estimator based on optimal
quantization}, Manuscript in preparation.
}
\seealso{
\code{\link{QuantifQuantile.d2}} and \code{\link{QuantifQuantile.d}}
 for multivariate versions.

\code{\link{plot.select.N.QuantifQuantile}} for the \code{N}
selection criterion.

\code{\link{plot.QuantifQuantile}},
\code{\link{print.QuantifQuantile}}, \code{\link{summary.QuantifQuantile}}
}

