% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBC_dichotom.R
\name{boot_optim_dichotom}
\alias{boot_optim_dichotom}
\title{Bootstrap-based Optimism Correction}
\usage{
boot_optim_dichotom(formula, data, contX, ...)
}
\arguments{
\item{formula}{\link[stats]{formula}, left-hand-side being the endpoint and
right-hand-side being the predictors \emph{in addition to} the \link[base]{numeric} predictor(s) to be dichotomized.
If there is no additional predictors, use \code{y ~ 1}}

\item{data}{\link[base]{data.frame}}

\item{contX}{\link[base]{character} scalar,
name of the \link[base]{matrix} column in \code{data}
which contains the \link[base]{numeric} predictor(s) to be dichotomized}

\item{...}{additional parameters of \link[boot]{boot}, most importantly the number of bootstrap replicates \code{R}}
}
\value{
\link{boot_optim_dichotom} returns a \link[base]{numeric} \link[base]{vector} of
median optimism estimate, with \link[base]{attributes}
\describe{
\item{\code{attr(,'boot_branch')}}{a \link[base]{list} of length \eqn{R}, each element of which is
a \link[base]{list} of \link[base]{language} objects (see attribute \code{'branch'} of \link{m_rpartD})}
}
}
\description{
Computes optimism correction for effect sizes corresponding to dichotomized \link[base]{numeric} predictor(s).
}
\details{
\eqn{R} bootstrap samples are generated. For each bootstrap sample,
dichotomizing branches for the \link[base]{numeric} predictors
are optimized in the bootstrap sample using \link{m_rpartD}

\describe{

\item{Bootstrap performance}{Regression coefficients for the dichotomized predictors are estimated
in the bootstrap sample via \link{coef_dichotom}}

\item{Test performance}{Regression coefficients for the dichotomized predictors are estimated
in the entire data set via \link{coef_dichotom}}. The \link[base]{numeric} predictors in the entire data set are dichotomized
using dichotomizing branches determined in the bootstrap sample.

}

The \emph{optimism or optimistic bias} is estimated by the difference between regression coefficients
from bootstrap performance and test performance, for each of the \eqn{R} bootstrap sample.

The \emph{median optimism estimate} is the median of optimism estimates over all \eqn{R} bootstrap samples.
}
\examples{
# see ?`Qindex-package`

}
\references{
Ewout W. Steyerberg (2009) Clinical Prediction Models.
\doi{10.1007/978-0-387-77244-8}

Frank E. Harrell Jr., Kerry L. Lee, Daniel B. Mark. (1996) Multivariable prognostic models: issues in developing models, evaluating
assumptions and adequacy, and measuring and reducing errors.
\doi{10.1002/(SICI)1097-0258(19960229)15:4<361::AID-SIM168>3.0.CO;2-4}
}
