% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0gam_ext.R
\name{FR_gam}
\alias{FR_gam}
\title{Using \link[mgcv]{gam} for Functional Regression}
\usage{
FR_gam(
  y,
  X,
  xarg = as.numeric(colnames(X)),
  family,
  knot_pct = 0.4,
  knot.value = ceiling(length(xarg) * knot_pct),
  ...
)
}
\arguments{
\item{y}{either a \link[base]{numeric} \link[base]{vector},
a \link[base]{logical} \link[base]{vector},
or a \link[survival]{Surv} object.}

\item{X}{\link[base]{numeric} \link[base]{matrix} of tabulated functional predictor.
Each row represents the tabulated, on a common grid,
functional predictor values for each subject.
Each column corresponds to the same point on the common grid.}

\item{xarg}{\link[base]{numeric} \link[base]{vector}, default to
\code{as.numeric(colnames(X))}}

\item{family}{\link[stats]{family} object specifying the distribution
and link to use in \link[mgcv]{gam}}

\item{knot_pct}{\link[base]{numeric} scalar,
percentage of the number of columns of \code{X},
to be used as \code{knot.value}.
Default is \eqn{40\%}.
If \code{knot.value} is provided by the end-user, then \code{knot_pct} is ignored.}

\item{knot.value}{\link[base]{integer} scalar, number of knots
(i.e., parameter \code{k} in the spline smooth function \link[mgcv]{s})
used in \link[mgcv]{gam}.
Default is the \link[base]{ceiling} of \code{knot_pct} of
the column dimension of the \link[base]{matrix} column \code{contX}.}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{FR_gam} returns a \link[mgcv]{gam} object
}
\description{
Estimate the functional coefficient by fitting functional regression model (via \link[mgcv]{gam}).
}
\details{
Using \link[mgcv]{gam} to estimate the functional coefficient by fitting functional regression model.
}
\examples{
Ki67q = clusterQp(data = Ki67, 
  exclude = c('tissueID','inner_x','inner_y'), contX = 'Marker')
Ki67q$Marker = log1p(Ki67q$Marker)

yy = FR_gam(
 y = with(Ki67q, expr = survival::Surv(RECFREESURV_MO, RECURRENCE)),
 X = Ki67q[['Marker']])

}
\references{
Cui, E., Crainiceanu, C. M., & Leroux, A. (2021). Additive Functional Cox Model. Journal of Computational and Graphical Statistics. 2021;30(3):780-793.
\doi{10.1080/10618600.2020.1853550}

Gellar, J. E., Colantuoni, E., Needham, D. M., & Crainiceanu, C. M. (2015). Cox regression models with functional covariates for survival data. Statistical Modelling, 15(3), 256-278.
\doi{10.1177/1471082X14565526}
}
