#' Original data used by Schwarz (2016)
#'
#' A dataset containing the calibrated set values for the article:
#' Schwarz, Oliver (2016): Two Steps Forward One Step Back: 
#' What Shapes the Process of EU Enlargement in South-Eastern Europe? 
#' Journal of European Integration 38 (7): 757-773.
#'
#' @format A data frame with 74 rows and 9 variables:
#' \describe{
#'   \item{Case.ID}{Country-year ID}
#'   \item{enlarge}{Progress in the EU accession process}
#'   \item{poltrans}{Democracy status of the country}
#'   \item{ecotrans}{Market economy status of the country}
#'   \item{reform}{State of reform policy}
#'   \item{conflict}{Mean conflict intensity in a country per year}
#'   \item{attention}{EU’s attention to the issue of enlargement}
#'   \item{year}{Year ID}
#'   \item{country}{Country ID}
#' }
#' @source Schwarz (2016) <doi:10.1080/07036337.2016.1203309>
"Schwarz2016"

#' Original data used by Thiem (2011)
#'
#' A dataset containing the calibrated set values for the article:
#' Thiem, Alrik (2011): 
#' Conditions of Intergovernmental Armaments Cooperation in Western Europe,
#'  1996-2006. European Political Science Review 3 (1): 1-33.
#'
#' @format A data frame with 165 rows and 10 variables:
#' \describe{
#'   \item{id}{Country-year ID}
#'   \item{year}{Time ID}
#'   \item{country}{Country ID}
#'   \item{memberfs}{Monadic count of membership in formal intergovernmental 
#'   agreements on armaments cooperation}
#'   \item{fedismfs}{Degree to which a country’s domestic constitutional setup 
#'   is federalist in character}
#'   \item{homogtyfs}{Bilateral interaction scores based on all UN and NATO 
#'   military missions conducted between 1996 and 2006}
#'   \item{powdifffs}{Score to measure a country's military power based on the 
#'   CINC score}
#'   \item{comptvnsfs}{Competitiveness of a country’s domestic armaments 
#'   industry}
#'   \item{pubsupfs}{Public support for cooperation in defence}
#'   \item{ecodpcefs}{Degree of economic dependence}
#' }
#' @source Thiem(2011) <doi:10.1017/S1755773910000251>
"Thiem2011"

#' Original data used by Grauvogel/von Soest (2014)
#'
#' A dataset containing the calibrated set values for the article:
#' Grauvogel, Julia and Christian von Soest (2014):  
#' Claims to Legitimacy Count: Why Sanctions Fail to Instigate 
#' Democratisation in Authoritarian Regimes.  
#' European Journal of Political Research 53 (4): 635-653.
#'
#' @format A data frame with 120 rows and 10 variables:
#' \describe{
#'   \item{Code}{Sender-target ID}
#'   \item{Sender}{Country or institution imposing sanctions}
#'   \item{Target}{Country that is target of sanctions}
#'   \item{Timeframe}{Considered years for each country case}
#'   \item{Persistence}{Degree of regime persistence after the intervention}
#'   \item{Comprehensiveness}{Scope of the imposed sanctions - comprehensive 
#'   vs. targeted sanctions}
#'   \item{Linkage}{Economic and social, respectively communicative and 
#'   geographic ties}
#'   \item{Vulnerability}{Military and economic vulnerability of the state to 
#'   outside pressure}
#'   \item{Repression}{Degree of repression by the state}
#'   \item{Claims}{Variety and strength of claims to legitimacy}
#' }
#' @source Grauvogel (2014) <doi:10.1111/1475-6765.12065>
"Grauvogel2014"

