% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_program}
\alias{set_program}
\title{Set the Current Active Breeding Program}
\usage{
set_program(program_name)
}
\arguments{
\item{program_name}{The name of the breeding program.}
}
\value{
No return value.
}
\description{
Updates the current active breeding program in the internal state object 
using the programDbId which is associated with the given program_name parameter.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{list_programs}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
