% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_compounds.R
\name{get_compounds}
\alias{get_compounds}
\title{Retrieve Compounds from PubChem}
\usage{
get_compounds(identifier, namespace = "cid", searchtype = NULL, ...)
}
\arguments{
\item{identifier}{A vector of positive integers (e.g. cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, only a single identifier string (name, smiles, xref; inchi, sdf by POST only).}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey', 'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure', 'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{...}{Additional parameters passed to \code{\link{get_json}}.}
}
\value{
A named list where each element corresponds to a compound retrieved from PubChem.
        The names of the list elements are based on the provided identifiers.
        If no compound is found for a given identifier, the corresponding list element will contain the string "No compound".
}
\description{
This function sends a request to PubChem to retrieve compound data based on the specified parameters.
It returns a list of compounds corresponding to the provided identifiers.
}
\examples{
get_compounds(
  identifier = "aspirin",
  namespace = "name"
)
}
