% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{inpainting}
\alias{inpainting}
\title{image recovery using Lasso regression}
\usage{
inpainting(image,h,stride,i,j,width,height,lambda=0.1,max_iter=50000,
fista=TRUE, verbose=TRUE,ini=0,glmnet=TRUE,noise=TRUE)
}
\arguments{
\item{image}{image to be modified, it has to be a 3D array proceed with readImage function from EBImage package}

\item{h}{size of the patch}

\item{stride}{stride for the patch}

\item{i}{row index of the upper left corner of the rectangle}

\item{j}{column index of the upper left corner of the rectangle}

\item{width}{width of the rectangle}

\item{height}{height of the rectangle}

\item{lambda}{a penalized parameter for the Lasso regression, it is 0.1 by default}

\item{max_iter}{maximum number of iterations, it is 50000 by default}

\item{fista}{fista=TRUE: use FISTA algortihm for the pixel prediction}

\item{verbose}{print the iteration number and the size of the boundary}

\item{ini}{initial value for the coefficients, default is 0}

\item{glmnet}{use glmnet package for the Lasso regression}

\item{noise}{display the image with the hole, it is TRUE by default}
}
\value{
a 3D array with the hole filled by pixels predicted by Lasso regression
}
\description{
predicts the missing pixels in an image using Lasso regression and fills the hole in the image
}
\details{
inpainting
}
\examples{
test_img <- EBImage::readImage(system.file("extdata", "bird.jpg", package = "ProxReg"))
image_repaired <- inpainting(
  test_img, h = 10, stride = 6, i = 160, j = 160, width = 20, height = 20,
  lambda = 0.001, max_iter = 1000, verbose = TRUE, glmnet = TRUE,noise=TRUE)
RGB_repaired<-EBImage::Image(image_repaired,colormode = "Color")
}
