% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covls.R
\name{names.procmod_corls}
\alias{names.procmod_corls}
\title{The Names of the elements of a Correlation Matrix}
\usage{
\method{names}{procmod_corls}(x)
}
\arguments{
\item{x}{a \code{procmod_corls} object}
}
\description{
Returns the names of the elements associated to a \code{procmod_corls}
object.
}
\examples{
# Build Three matrices of 3 rows.
A <- simulate_matrix(10,3)
B <- simulate_matrix(10,5)
C <- simulate_correlation(B,10,r2=0.6)

# Computes the correlation matrix
data <- procmod_frame(A = A, B = B, C = C)
cls <- corls(data, nrand = 100)

names(cls)

}
\seealso{
\code{\link[ProcMod]{corls}}
}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
