% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{patternOrderLength}
\alias{patternOrderLength}
\alias{patternOrderLength,PTModule-method}
\alias{patternOrderLength<-}
\alias{patternOrderLength<-,PTModule,numeric-method}
\title{Get the length of the pattern order table}
\usage{
\S4method{patternOrderLength}{PTModule}(x)

\S4method{patternOrderLength}{PTModule,numeric}(x) <- value
}
\arguments{
\item{x}{A \code{\link{PTModule}} object for which the length of the
visible part of the pattern order table is to be returned.}

\item{value}{A \code{numeric} value which is to be used to set the visible
length of the pattern order table.}
}
\value{
For \code{patternOrderLength} the visible length of the pattern
order table of \code{\link{PTModule}} \code{x} is returned as a \code{numeric}
value, ranging from 1 up to 128.

For \code{patternOrderLength<-} an updated version of object \code{x} is
returned, in which the visible length of the pattern order table is set
to \code{value}. Note that this does not change the pattern order table
itself, only which part is `visible'.
}
\description{
The pattern order table is a \code{vector} of \code{numeric} indices of
\code{PTPattern} tables, which determines in which order the patterns
need to be played. This method returns the visible length of this
\code{vector}.
}
\details{
The actual length of the \code{vector} containing the pattern order is 128
as per ProTracker standards. Only part of this \code{vector} is `visible'
and will be used to determine in which order pattern tables are to be played.
The length returned by this method is the length of this visible part of the
pattern order table. The length of this visible part can also be set with this
method.
}
\examples{
data("mod.intro")

## get the length of the pattern order table:
patternOrderLength(mod.intro)

## set the length of the pattern order table to 1:
patternOrderLength(mod.intro) <- 1

## note that the pattern order table remained intact:
patternOrder(mod.intro, full = TRUE)

}
\seealso{
Other pattern.operations: \code{\link{MODPlugToPTPattern}},
  \code{\link{PTPattern-class}},
  \code{\link{PTPattern-method}},
  \code{\link{PTPatternToMODPlug}},
  \code{\link{appendPattern}}, \code{\link{deletePattern}},
  \code{\link{pasteBlock}}, \code{\link{patternLength}},
  \code{\link{patternOrder}}

Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{deletePattern}},
  \code{\link{fix.PTModule}}, \code{\link{modToWave}},
  \code{\link{moduleSize}}, \code{\link{patternLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}
}
\author{
Pepijn de Vries
}
