% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04PTPattern.r
\docType{class}
\name{PTPattern-class}
\alias{PTPattern-class}
\alias{PTPattern}
\title{The PTPattern class}
\description{
The \code{PTPattern} (or simply pattern) is a table that determines which
samples are played at which notes in which octave, in which order and with
which effects.
}
\details{
When a \code{PTPattern} table (or simply pattern) is played, each of the 64
rows (see the green mark in the illustration below for an example of a row)
are played subsequently at a specified speed/tempo.

Note that ProTracker uses row indices that start at zero. However, this package
uses indices starting at one, conform R language definitions.

\if{html}{\figure{patterntable.png}{Pattern Table}}
\if{latex}{\figure{patterntable.pdf}{options: width=6in}}

The table has four columns (see the purple outline in the illustration
above as an example of a column), representing the four audio channels (\code{\link{PTTrack}})
of the Commodore Amiga. Samples listed in the same row at different
tracks will be played simultaneously.

An element at a specific row and track will be referred to as a \code{\link{PTCell}}
(or simply cell). The cell determines which sample needs to be played at
which note and octave and what kind of \code{\link{effect}} or trigger should
be applied.

With the \code{\link{PTPattern-method}}, objects can be coerced to a pattern
table. This method can also be used to extract or replace patterns in
\code{\link{PTModule}} objects.
}
\section{Slots}{

\describe{
\item{\code{data}}{A \code{matrix} (64 rows, 16 columns) of class "\code{raw}".
Each row contains the \code{raw} concatenated data of 4 \code{\link{PTCell}} objects,
representing each of the 4 audio channels/tracks (as each \code{\link{PTCell}} object holds
4 \code{raw} values, each row holds 4 x 4 = 16 \code{raw}
values). The \code{raw} data is formatted conform the specifications given
in the \code{\link{PTCell}} documentation.}
}}

\seealso{
Other pattern.operations: \code{\link{MODPlugToPTPattern}},
  \code{\link{PTPattern-method}},
  \code{\link{PTPatternToMODPlug}},
  \code{\link{appendPattern}}, \code{\link{deletePattern}},
  \code{\link{pasteBlock}}, \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}
}
\author{
Pepijn de Vries
}
