# Convenient function to flatten a list into another list and
# avoid coercion into a single type (usually numeric/double)
# Below is currently not used due to code simplification- might want to add back
# in if modellist gain a variety of data types in the future.
# .renquote = function(l) if (is.vector(l) && (length(l) > 1 || is.list(l))) lapply(l, .renquote) else enquote(l)
# .flattenlist = function(ml) lapply(unlist(.renquote(ml)), eval)
# .rrelist = function(flesh, skeleton=attr(flesh, "skeleton")){
#   index = 1
#   result = skeleton
#   for (i in 1:length(skeleton)) {
#     size = length(unlist(result[[i]]))
#     if(is.list(result[[i]])) {
#       result[[i]] = .rrelist(flesh[index:(index + size - 1)], result[[i]])
#     } else if(size >1) {
#       result[[i]] = relist(flesh[index:(index + size - 1)], result[[i]])
#     } else {
#       result[[i]] = flesh[[index]]
#     }
#     index <- index + size
#   }
#   result
# }
# On stack overflow this solution was offered:
# relist2 = function(x, like, relist.vectors=F) {
#    if (! relist.vectors) 
#        like = rapply(a, function(f) NA, how='replace')
#    lapply(relist(x, skeleton=like), function(e) unlist(e, recursive=F))
# }

profitLikeModel=function(parm, Data, makeplots=FALSE, 
  whichcomponents=list(sersic="all",moffat="all",ferrer="all",pointsource="all"), rough=FALSE,
  cmap = rev(colorRampPalette(brewer.pal(9,'RdYlBu'))(100)), errcmap=cmap, plotchisq=FALSE) {
  if(class(Data)!='profit.data'){stop("The Data must be of class profit.data, as generated by the profitSetupData function!")}
  usecovar = FALSE
  finesample = 1L
  if(length(Data$finesample)>0) finesample = Data$finesample
  profitCheckFinesample(finesample)
  
  fitIDs=which(unlist(Data$tofit))
  parm=parm[1:length(fitIDs)]
  paramsinit=unlist(Data$modellist)
  paramsnew=paramsinit
  paramsnew[fitIDs]=parm
  
  # Flatten or unlist?
  tounlogIDs=which(unlist(Data$tolog) & unlist(Data$tofit))
  for(i in tounlogIDs){
    paramsnew[i]=10^paramsnew[i]
  }
  # Inherit values for NA flags
  inheritIDs=which(is.na(unlist(Data$tofit)))
  for(i in inheritIDs) paramsnew[i]=paramsnew[i-1]
  
  # Re-list the new linear modellist
  modellistnew=relist(paramsnew,Data$modellist)
  
  # Apply constraints to the new linear modellist
  if(length(Data$constraints)>0){
    modellistnew=Data$constraints(modellistnew)
  }
  
  # Specify interval limits on the now linear data
  if(length(Data$intervals)>0){
    #paramsnew = unlist(modellistnew)
    #intervals = unlist(Data$intervals)
    #for(i in 1:length(paramsnew)){
    #  paramsnew[i]=max(intervals[(i-1)*2+1], min(intervals[(i-1)*2+2], paramsnew[i], na.rm = FALSE), na.rm = FALSE)
    #}
    ## Re-list the new linear modellist
    #modellistnew=relist(paramsnew,Data$modellist)
    #New approach, to deal with partial interval limits:
    compnames=names(Data$intervals)
      for(i in compnames){
        subnames=names(Data$intervals[[i]])
        for(j in subnames){
          subsublength=length(modellistnew[[i]][[j]])
          for(k in 1:subsublength){
          modellistnew[[i]][[j]][k]=max(Data$intervals[[i]][[j]][[k]][1], min(Data$intervals[[i]][[j]][[k]][2], modellistnew[[i]][[j]][k], na.rm = FALSE), na.rm = FALSE)
          }
        }
      }
    
  }
  
  # Calculate priors with the new versus old modellist
  if(length(Data$priors)>0){
    priorsum=Data$priors(modellistnew,Data$modellist)
  }else{
    priorsum=0
  }
  
  # Unlist and extract the tofit elements and log where required
  paramsnew=unlist(modellistnew)
  for(i in tounlogIDs){
    paramsnew[i]=log10(paramsnew[i])
  }
  
  # Specify the new parm to be parsed back to the external optimisation function
  parm=paramsnew[fitIDs]
  
  if(Data$fitpsf) {
    psf = profitMakePointSource(modellist=model$psf, finesample = finesample) 
  } else {
    psf = Data$psf
  }
  
  if(Data$usecalcregion){
    model = profitMakeModel(modellist=modellistnew, magzero = Data$magzero, psf=Data$psf, dim=Data$imagedim, 
      whichcomponents = whichcomponents, rough=rough, calcregion=Data$calcregion, docalcregion=Data$usecalcregion,
      magmu=Data$magmu,finesample=finesample, convopt=Data$convopt)
  }else{
    model = profitMakeModel(modellist=modellistnew, magzero = Data$magzero, psf=Data$psf, dim=Data$imagedim, 
      whichcomponents = whichcomponents, rough=rough, magmu=Data$magmu, finesample=finesample, convopt=Data$convopt)
  }
  
  if(any(Data$region)) {
    cutim=Data$image[Data$region]
    cutmod=model$z[Data$region]
    cutsig=Data$sigma[Data$region] 
  } else {
    cutim=Data$image
    cutmod=model$z
  }
  
  #Force like.func to be lower case:
  Data$like.func=profitParseLikefunc(Data$like.func)
  
  #Various allowed likelihoods:
  isnorm = Data$like.func == "norm"
  ischisq = Data$like.func == "chisq"
  ist = Data$like.func == "t"
  if(isnorm || ischisq || ist) {
    cutsig=(cutim-cutmod)/cutsig
  }
  if(isnorm){
    LL=sum(dnorm(cutsig, log=TRUE))
  } else if(ischisq) {
    ndata = length(cutim)
    LL=dchisq(sum(cutsig^2), ndata, log=TRUE)
  } else if(ist) {
    vardata = var(cutsig)
    dof=2*vardata/(vardata-1)
    dof=interval(dof,0,Inf)
    LL=sum(dt(cutsig,dof,log=TRUE))
  } else if(Data$like.func=="pois") {
    scale=max(abs(Data$image)/abs(Data$sigma)^2)
    if(scale<0.1 | scale>10){
      cutmod=cutmod*scale
      cutim=cutim*scale
    }
    LL=-sum(cutmod-cutim*log(cutmod))
  } else {
    stop(paste0("Error: unknown likelihood function: '",Data$like.func,"'"))
  }
  
  if(makeplots){
    skylevel = 0
    if(!is.null(modellistnew$sky) && !is.null(modellistnew$sky$bg) && is.numeric(modellistnew$sky$bg)) skylevel = modellistnew$sky$bg
    profitMakePlots(Data$image-skylevel,model$z-skylevel,Data$region, Data$sigma, cmap=cmap, errcmap=errcmap,plotchisq=plotchisq)
  }
  
  LP=as.numeric(LL+priorsum)
  if(Data$verbose){print(c(parm,LP),digits = 5)}
  if(Data$algo.func=='') return(list(model=model,psf=psf))
  if(Data$algo.func=='optim' | Data$algo.func=='CMA'){out=LP}
  if(Data$algo.func=='LA' | Data$algo.func=='LD'){
    if(ist) Monitor=c(LL=LL,LP=LP,dof=dof) else Monitor=c(LL=LL,LP=LP)
    out=list(LP=LP,Dev=-2*LL,Monitor=Monitor,yhat=1,parm=parm)
  }
  return(out)
}