% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_full_multilateral_indices.R
\name{geksiqm}
\alias{geksiqm}
\title{Calculating the multilateral GEKS-IQM price index}
\usage{
geksiqm(data, start, end, r = 2, wstart = start, window = 13)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{r}{The real and non-zero parameter used in the implicit quadratic mean of order r price index.}

\item{wstart}{The beginning of the time interval (which is used by multilateral methods) limited to the year and month, e.g. "2020-01".}

\item{window}{The length of the time window (as positive integer: typically multilateral methods are based on the 13-month time window).}
}
\value{
This function returns a value of the multilateral GEKS-IQM price index (to be more precise: the GEKS index based on the the implicit quadratic mean of order r price index IQMp) which considers the time window defined by \code{wstart} and \code{window} parameters. It measures the price dynamics by comparing period \code{end} to period \code{start} (both \code{start} and \code{end} must be inside the considered time window). To get information about both price index values and corresponding dates, please see functions: \code{\link{price_indices}} or \code{\link{final_index}}. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} function).
}
\description{
This function returns a value of the multilateral GEKS-IQM price index (to be more precise: the GEKS index based on the implicit quadratic mean of order r price index IQMp).
}
\examples{
\donttest{geksiqm(milk, start="2019-01", end="2019-08",window=10)}
\donttest{geksiqm(milk, start="2018-12", end="2019-12", r=1.6)}
}
\references{
{Gini, C. (1931). \emph{On the Circular Test of Index Numbers.} Metron 9:9, 3-24.}

{Elteto, O., and Koves, P. (1964). \emph{On a Problem of Index Number Computation Relating to International Comparisons.} Statisztikai Szemle 42, 507-518.}

{Szulc, B. (1983). \emph{Linking Price Index Numbers.} In: Price Level Measurement, W. E. Diewert and C. Montmarquette (eds.), 537-566.}

{(2004). \emph{Consumer Price Index Manual. Theory and practice}. ILO/IMF/OECD/UNECE/Eurostat/The World Bank, International Labour Office (ILO), Geneva.}
}
