% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_full_multilateral_indices.R
\name{SPQ}
\alias{SPQ}
\title{Calculating the multilateral SPQ price index}
\usage{
SPQ(data, start, end, interval = FALSE)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. '2019-03'.}

\item{end}{The research period (as character) limited to the year and month, e.g. '2019-07'.}

\item{interval}{A logical value indicating whether the function is to compare the research period defined by \code{end} to the base period defined by \code{start} (then \code{interval} is set to FALSE) or all fixed base indices are to be calculated. In this latter case, all months from the time interval \code{<start,end>} are considered and \code{start} defines the base period (\code{interval} is set to TRUE).}
}
\value{
This function returns a value of the multilateral SPQ price index which is based on the relative price and quantity dissimilarity measure (see \code{References}). If the \code{interval} parameter is set to TRUE, the function returns a vector of price index values without dates. To get information about both price index values and corresponding dates, please see functions: \code{\link{price_index}}, \code{\link{price_indices}}, \code{\link{final_index}} or \code{\link{final_index2}}. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} or \code{\link{final_index2}} function).
}
\description{
This function returns a value of the multilateral SPQ price index which is based on the relative price and quantity dissimilarity measure.
}
\examples{
\donttest{SPQ(sugar, start="2018-12",end="2019-02")}
\donttest{SPQ(milk, start="2018-12",end="2019-12",interval=TRUE)}
}
\references{
{Diewert, E. (2020). \emph{The Chain Drift Problem and Multilateral Indexes.} Chapter 6 in: Consumer Price Index Theory (draft)}
}
