% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{loglik.linear.model}
\alias{loglik.linear.model}
\title{Profile log-likelihood or fixed parameters likelihood evaluation for the covariance parameters in the geostatistical linear model}
\usage{
loglik.linear.model(
  object,
  control.profile,
  plot.profile = TRUE,
  messages = TRUE
)
}
\arguments{
\item{object}{an object of class 'PrevMap', which is the fitted linear model obtained with the function \code{\link{linear.model.MLE}}.}

\item{control.profile}{control parameters obtained with \code{\link{control.profile}}.}

\item{plot.profile}{logical; if \code{TRUE} a plot of the computed profile likelihood is displayed.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}
}
\value{
an object of class "profile.PrevMap" which is a list with the following values

\code{eval.points.phi}: vector of the values used for \code{phi} in the evaluation of the likelihood.

\code{eval.points.rel.nugget}: vector of the values used for \code{nu2} in the evaluation of the likelihood.

\code{profile.phi}: vector of the values of the likelihood function evaluated at \code{eval.points.phi}.

\code{profile.rel.nugget}: vector of the values of the likelihood function evaluated at \code{eval.points.rel.nugget}.

\code{profile.phi.rel.nugget}: matrix of the values of the likelihood function evaluated at \code{eval.points.phi} and \code{eval.points.rel.nugget}.

\code{fixed.par}: logical value; \code{TRUE} is the evaluation if the likelihood is carried out by fixing the other parameters, and \code{FALSE} if the computation of the profile-likelihood was performed instead.
}
\description{
Computes profile log-likelihood, or evaluatesx likelihood keeping the other paramaters fixed, for the scale parameter \code{phi} of the Matern function and the relative variance of the nugget effect \code{nu2} in the linear Gaussian model.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
