% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{Laplace.sampling.SPDE}
\alias{Laplace.sampling.SPDE}
\title{Independence sampler for conditional simulation of a Gaussian process using SPDE}
\usage{
Laplace.sampling.SPDE(
  mu,
  sigma2,
  phi,
  kappa,
  y,
  units.m,
  coords,
  mesh,
  control.mcmc,
  messages = TRUE,
  plot.correlogram = TRUE,
  poisson.llik
)
}
\arguments{
\item{mu}{mean vector of the Gaussian process to approximate.}

\item{sigma2}{variance of the Gaussian process to approximate.}

\item{phi}{scale parameter of the Matern function for the Gaussian process to approximate.}

\item{kappa}{smothness parameter of the Matern function for the Gaussian process to approximate.}

\item{y}{vector of binomial observations.}

\item{units.m}{vector of binomial denominators.}

\item{coords}{matrix of two columns corresponding to the spatial coordinates.}

\item{mesh}{mesh object set through \code{inla.mesh.2d}.}

\item{control.mcmc}{control parameters of the Independence sampler set through \code{\link{control.mcmc.MCML}}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}

\item{plot.correlogram}{logical; if \code{plot.correlogram=TRUE} the autocorrelation plot of the conditional simulations is displayed.}

\item{poisson.llik}{logical: if \code{poisson.llik=TRUE} then conditional conditional distribution of the data is Poisson; \code{poisson.llik=FALSE} then conditional conditional distribution of the data is Binomial.}
}
\value{
A list with the following components

\code{samples}: a matrix, each row of which corresponds to a sample from the predictive distribution.
}
\description{
This function simulates from the conditional distribution of a Gaussian process given binomial \code{y}.
The Guassian process is also approximated using SPDE.
}
\details{
\bold{Binomial model.} Conditionally on the random effect \eqn{S}, the data \code{y} follow a binomial distribution with probability \eqn{p} and binomial denominators \code{units.m}. The logistic link function is used for the linear predictor, which assumes the form \deqn{\log(p/(1-p))=S.}
The random effect \eqn{S} has a multivariate Gaussian distribution with mean \code{mu} and covariance matrix \code{Sigma}.
}
\seealso{
\code{\link{control.mcmc.MCML}}.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
