/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.portfolioeffect.quant.client.Connector;
import com.portfolioeffect.quant.client.message.ClientMessage;
import com.portfolioeffect.quant.client.message.LogoutResponse;
import com.portfolioeffect.quant.client.message.Reject;
import com.portfolioeffect.quant.client.message.ServiceMessage;
import com.portfolioeffect.quant.client.message.TestRequest;
import com.portfolioeffect.quant.client.message.ValidationRequest;
import com.portfolioeffect.quant.client.message.type.EncryptMethodType;
import com.portfolioeffect.quant.client.message.type.EncryptedPasswordMethodType;
import com.portfolioeffect.quant.client.message.type.FastMessageType;
import com.portfolioeffect.quant.client.message.util.ClientRequestMessageFactory;
import com.portfolioeffect.quant.client.message.util.ClientRequestMessageParser;
import com.portfolioeffect.quant.client.message.util.CryptograhicUtils;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageParser;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.Console;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageInputStream;
import org.openfast.MessageOutputStream;
import org.openfast.error.FastException;
import org.openfast.examples.MessageBlockReaderFactory;
import org.openfast.examples.MessageBlockWriterFactory;
import org.openfast.examples.OpenFastExample;
import org.openfast.session.Connection;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.tcp.TcpEndpoint;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class ConnectionToServer {
    private static final int MILLISEC_IN_SECOND = 1000;
    public static final String STREAM_IS_ALREADY_RUNNING = "Stream is already running";
    private static final int TIME_WAIT_TOPRINT = 20;
    private static final int TEST_PORT_NUMBER = 3443;
    private static final int LOGON_TIMEOUT_SECONDS = 10;
    private static final int SERVICE_TIMEOUT_SEC = 30;
    private static final int PORT_NUMBER = 443;
    private static final String TEMPLATES_FILE = "config/template-quant.xml";
    private static final int LOGON_ATTEMPT_COUNT = 9;
    private static final int DEFAULT_LOGON_TIMEOUT_SEC = 30;
    private static final int HEARTBEAT_INTERVAL = 30;
    private static final EncryptMethodType ENCRYPT_METHOD_TYPE = EncryptMethodType.NONE;
    private static boolean IS_OLD_CONNECTION = false;
    private int restarTimeWait = 180;
    private String apiKey;
    private String username;
    private String password;
    private String templatesFileName;
    private String host;
    private int port;
    private Connection connection;
    private volatile MessageOutputStream out;
    private volatile MessageInputStream in;
    private MessageBlockWriterFactory messageBlockWriterFactory;
    private MessageBlockReaderFactory messageBlockReaderFactory;
    private volatile boolean isLoggedOn = false;
    private volatile boolean isConnected = false;
    private volatile boolean isConnectBreaked = false;
    private boolean isMessageLoggingEnabled = true;
    private Thread inboundMessageRouter;
    private Endpoint endpoint;
    private TemplateRegistry templateRegistry;
    private AtomicInteger outboundMsgSeqNum = new AtomicInteger(0);
    private volatile ConcurrentHashMap<Integer, LinkedBlockingDeque<ClientMessage>> clientMessageQueue;
    private volatile LinkedBlockingDeque<ServiceMessage> serviceMessageQueue;
    private boolean debugModeEnabled = false;
    private Thread heartbeatMonitor;
    private static volatile ConnectionToServer curentConnection = new ConnectionToServer();
    private volatile int connectorsNumber = 0;
    private volatile ReentrantLock lock = new ReentrantLock();
    private static volatile ReentrantLock lockStatic = new ReentrantLock();

    public static void resetConnection() {
        lockStatic.lock();
        curentConnection = new ConnectionToServer(curentConnection);
        lockStatic.unlock();
    }

    private ConnectionToServer() {
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        this.port = 443;
        this.clientMessageQueue = new ConcurrentHashMap();
        this.clientMessageQueue.put(0, new LinkedBlockingDeque());
        this.serviceMessageQueue = new LinkedBlockingDeque();
    }

    private ConnectionToServer(ConnectionToServer connectionToServer) {
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        this.port = 443;
        this.clientMessageQueue = new ConcurrentHashMap();
        this.clientMessageQueue.put(0, new LinkedBlockingDeque());
        this.serviceMessageQueue = new LinkedBlockingDeque();
        this.apiKey = connectionToServer.apiKey;
        this.username = connectionToServer.username;
        this.password = connectionToServer.password;
        this.host = connectionToServer.host;
        this.port = connectionToServer.port;
    }

    public static ConnectionToServer getCurentConnection() {
        lockStatic.lock();
        ConnectionToServer connectionToServer = curentConnection;
        lockStatic.unlock();
        return connectionToServer;
    }

    public Connector getCurentConnector(Connector connectorOld, int UID) {
        this.lock.lock();
        if (UID != 0 && this.clientMessageQueue.containsKey(UID)) {
            this.clientMessageQueue.remove(UID);
            this.logoutUID(UID);
        }
        Connector connector = new Connector(connectorOld, 0, curentConnection, this.clientMessageQueue.get(0));
        this.lock.unlock();
        return connector;
    }

    public Connector getNewConnector(Connector connectorOld) {
        this.lock.lock();
        ++this.connectorsNumber;
        this.clientMessageQueue.put(this.connectorsNumber, new LinkedBlockingDeque());
        Connector connector = new Connector(connectorOld, this.connectorsNumber, curentConnection, this.clientMessageQueue.get(this.connectorsNumber));
        this.lock.unlock();
        return connector;
    }

    private void connect() throws IOException, FastConnectionException {
        this.lock.lock();
        if (this.isConnected) {
            this.lock.unlock();
            return;
        }
        if (this.host.equals("localhost")) {
            this.port = 3443;
        }
        try {
            this.endpoint = new TcpEndpoint(this.host, this.port);
            XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader();
            loader.setLoadTemplateIdFromAuxId(true);
            loader.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.templatesFileName));
            this.templateRegistry = loader.getTemplateRegistry();
            Context context = new Context();
            context.setTemplateRegistry(this.templateRegistry);
            this.messageBlockWriterFactory = new MessageBlockWriterFactory(OpenFastExample.Variant.DEFAULT, 0, false);
            this.messageBlockReaderFactory = new MessageBlockReaderFactory(OpenFastExample.Variant.DEFAULT, 0, false);
            this.connection = this.endpoint.connect();
            this.in = new MessageInputStream(this.connection.getInputStream(), context);
            this.in.setBlockReader(this.messageBlockReaderFactory.create());
            this.out = new MessageOutputStream(this.connection.getOutputStream(), context);
            this.out.setBlockWriter(this.messageBlockWriterFactory.create());
            this.isConnected = true;
            this.inboundMessageRouter = new Thread(new InboundMessageWorker());
            this.inboundMessageRouter.start();
            this.heartbeatMonitor = new Thread(new HeartbeatMonitor());
            this.heartbeatMonitor.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (FastConnectionException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setConnectionBreak(String str) {
        if (this.isConnectBreaked) {
            return;
        }
        if (this.isDebugModeEnabled()) {
            Console.writeln("BREAK:" + str);
        }
        this.lock.lock();
        this.isConnectBreaked = true;
        for (LinkedBlockingDeque<ClientMessage> e : this.clientMessageQueue.values()) {
            e.offer(new ClientMessage(null, false, true));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.lock.unlock();
    }

    public void stop() {
        if (this.isConnected) {
            this.lock.lock();
            try {
                if (this.isLoggedOn) {
                    this.logout(10);
                }
                this.isLoggedOn = false;
                this.isConnected = false;
                this.endpoint.close();
                this.connection.close();
                this.inboundMessageRouter.join();
                this.serviceMessageQueue.offer(new ServiceMessage(System.currentTimeMillis(), true));
                this.heartbeatMonitor.interrupt();
            }
            catch (Exception e) {
                this.isLoggedOn = false;
                this.isConnected = false;
                this.lock.unlock();
                throw new RuntimeException("Error while stoping client.", e);
            }
            this.lock.unlock();
        }
    }

    void logon() {
        if (this.isLoggedOn) {
            return;
        }
        try {
            this.logon(30);
        }
        catch (Exception e) {
            this.setConnectionBreak("Logon -exception");
        }
    }

    private void logon(int timeoutSec) throws Exception {
        this.logon(timeoutSec, 0);
    }

    private void logon(int timeoutSec, int attemptCount) throws Exception {
        Message msg;
        this.lock.lock();
        if (this.isLoggedOn) {
            this.lock.unlock();
            return;
        }
        if (attemptCount > 9) {
            this.lock.unlock();
            return;
        }
        String encryptedPassword = CryptograhicUtils.encrypt(this.password, this.apiKey);
        Message loginMsg = ClientRequestMessageFactory.createLogonRequest(this.templateRegistry, 30, ENCRYPT_METHOD_TYPE, this.username, encryptedPassword, EncryptedPasswordMethodType.AES, encryptedPassword.length(), this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        try {
            msg = this.sendAndAwaitResponse(loginMsg, timeoutSec, true);
        }
        catch (Exception e) {
            this.lock.unlock();
            throw e;
        }
        FastMessageType responseMessageType = this.getMessageType(msg);
        if (responseMessageType == FastMessageType.LOGOUT) {
            LogoutResponse logoutReponse = ServerResponseMessageParser.parseLogoutResponse(msg);
            this.lock.unlock();
            throw new Exception(logoutReponse.getText());
        }
        if (attemptCount == 0 && !this.isLoggedOn) {
            this.lock.unlock();
            throw new ConnectFailedException();
        }
        this.lock.unlock();
    }

    private void logout(int timeoutSec) {
        if (!this.isLoggedOn) {
            return;
        }
        Message logoutMsg = ClientRequestMessageFactory.createLogoutRequest(this.templateRegistry, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        try {
            this.sendAndAwaitResponse(logoutMsg, timeoutSec);
            this.isLoggedOn = false;
        }
        catch (Exception e) {
            this.isLoggedOn = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoutUID(int UID) {
        this.lock.lock();
        try {
            if (this.isLoggedOn && UID > 0) {
                Message logoutMsg = ClientRequestMessageFactory.createLogoutRequest(this.templateRegistry, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                try {
                    this.send(UID, logoutMsg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setHost(String host) {
        this.lock.lock();
        this.host = host;
        if (host.equals("localhost")) {
            this.port = 3443;
        }
        this.lock.unlock();
    }

    public Metric start(int UID, String username, String password, String apiKey, String remoteHostName, int port) {
        this.port = port;
        return this.start(UID, username, password, apiKey, remoteHostName);
    }

    public Metric start(int UID, String username, String password, String apiKey, String remoteHostName) {
        this.lock.lock();
        if (this.isLoggedOn) {
            this.lock.unlock();
            return new Metric();
        }
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        try {
            Metric m = this.restart(UID, username, password, apiKey, remoteHostName);
            this.lock.unlock();
            return m;
        }
        catch (Exception e) {
            this.lock.unlock();
            if (e.getMessage().contains(":")) {
                return new Metric(e.getMessage().split(":")[1]);
            }
            return new Metric(e.getMessage());
        }
    }

    public Metric restart(int UID, String username, String password, String apiKey, String remoteHostName) {
        this.lock.lock();
        if (!this.isConnectBreaked && this.isConnected && this.isLoggedOn) {
            this.lock.unlock();
            return new Metric();
        }
        this.username = username;
        this.password = password;
        this.apiKey = apiKey;
        this.setHost(remoteHostName);
        int totalTime = 0;
        int waitTime = -1;
        while (totalTime < this.restarTimeWait) {
            ++waitTime;
            this.stop();
            try {
                if (waitTime >= 1) {
                    if ((totalTime += waitTime) > 20) {
                        Console.write("\nConnecting to  server.");
                    }
                    this.waitAndDots(waitTime, totalTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.connect();
                this.logon(10);
            }
            catch (IOException e) {
                continue;
            }
            catch (FastConnectionException e) {
                continue;
            }
            catch (ConnectFailedException e) {
                continue;
            }
            catch (Exception e) {
                this.lock.unlock();
                return new Metric(e.getMessage());
            }
            if (!this.isLoggedOn) continue;
            if (totalTime > 20) {
                Console.writeln(".OK.");
            }
            this.isConnectBreaked = false;
            this.lock.unlock();
            return new Metric();
        }
        if (!this.isLoggedOn) {
            this.lock.unlock();
            return new Metric("Cannot connect to server. Check remote host address and your firewall rules.");
        }
        this.isConnectBreaked = false;
        this.lock.unlock();
        return new Metric();
    }

    private void waitAndDots(int sec, int totalTime) throws InterruptedException {
        if (totalTime > 20) {
            Console.write(".");
        }
        Thread.sleep(sec * 1000);
    }

    private Message sendAndAwaitResponse(Message request, int timeoutSec) throws Exception {
        return this.sendAndAwaitResponse(request, timeoutSec, false);
    }

    private Message sendAndAwaitResponse(Message request, int timeoutSec, boolean isLogRequest) throws Exception {
        this.clientMessageQueue.get(0).clear();
        try {
            this.send(0, request, isLogRequest);
        }
        catch (Exception e) {
            throw new ConnectFailedException();
        }
        ClientMessage clientMessage = this.clientMessageQueue.get(0).poll(timeoutSec, TimeUnit.SECONDS);
        if (clientMessage == null) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isEmpty()) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isRejected()) {
            Reject reject = ServerResponseMessageParser.parseReject(clientMessage.getMessage());
            throw new Exception(reject.getText());
        }
        return clientMessage.getMessage();
    }

    public void send(int UID, Message request) throws Exception {
        this.send(UID, request, false);
    }

    public void send(int UID, Message request, boolean isLogRequest) throws Exception {
        this.lock.lock();
        if (!this.isConnected || !isLogRequest && !this.isLoggedOn) {
            this.lock.unlock();
            throw new ConnectFailedException();
        }
        try {
            if (!IS_OLD_CONNECTION && !isLogRequest && UID > 0) {
                Message UIDMsg = ClientRequestMessageFactory.createValidationRequest(this.getTemplateRegistry(), "" + UID, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                this.out.writeMessage(UIDMsg);
            }
            this.out.writeMessage(request);
        }
        catch (Exception e) {
            this.setConnectionBreak("Send exception");
            this.lock.unlock();
            throw new ConnectFailedException("Error writing to stream");
        }
        this.lock.unlock();
    }

    private void sendHeartbeat(String testReqId) throws Exception {
        Message logoutMsg = ClientRequestMessageFactory.createHeartbeat(this.templateRegistry, this.getOutboundMsgSequenceNumber(), testReqId);
        this.lock.lock();
        try {
            this.out.writeMessage(logoutMsg);
        }
        catch (Exception e) {
            this.setConnectionBreak("sendHearbeat exception");
            this.lock.unlock();
            throw new ConnectFailedException("Error writing to stream");
        }
        this.lock.unlock();
    }

    public TemplateRegistry getTemplateRegistry() throws Exception {
        if (this.templateRegistry == null) {
            throw new ConnectFailedException();
        }
        return this.templateRegistry;
    }

    private FastMessageType getMessageType(Message msg) {
        String msgTypeCode = msg.getString("MessageType");
        FastMessageType fastMsgType = FastMessageType.getFastMessageType(msgTypeCode);
        return fastMsgType;
    }

    public String getTemplatesFileName() {
        return this.templatesFileName;
    }

    public void setTemplatesFileName(String templatesFileName) {
        this.templatesFileName = templatesFileName;
    }

    public void setMessageLoggingEnabled(boolean isMessageLoggingEnabled) {
        this.isMessageLoggingEnabled = isMessageLoggingEnabled;
    }

    public boolean isMessageLoggingEnabled() {
        return this.isMessageLoggingEnabled;
    }

    public boolean isLoggedOn() {
        return this.isConnected && this.isLoggedOn;
    }

    public int getOutboundMsgSequenceNumber() {
        return this.outboundMsgSeqNum.getAndIncrement();
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public int getRestarTimeWait() {
        return this.restarTimeWait;
    }

    public void setRestarTimeWait(int restarTimeWait) {
        this.restarTimeWait = restarTimeWait;
    }

    private class HeartbeatMonitor
    implements Runnable {
        private HeartbeatMonitor() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    ServiceMessage serviceMessage = (ServiceMessage)ConnectionToServer.this.serviceMessageQueue.poll(30L, TimeUnit.SECONDS);
                    if (serviceMessage == null) {
                        ConnectionToServer.this.setConnectionBreak("HeartbeatMonitor servise msg");
                        continue;
                    }
                    if (!serviceMessage.isTerminated()) continue;
                }
                catch (Exception e) {
                    ConnectionToServer.this.setConnectionBreak("HeartbeatMonitor exception");
                }
                break;
            }
        }
    }

    private class InboundMessageWorker
    implements Runnable {
        private InboundMessageWorker() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int UID = 0;
                    Message msg = ConnectionToServer.this.in.readMessage();
                    if (msg != null) {
                        FastMessageType responseMessageType;
                        if (!IS_OLD_CONNECTION && (responseMessageType = ConnectionToServer.this.getMessageType(msg)) == FastMessageType.METRIC_VALIDATION_REQUEST) {
                            ValidationRequest UIDREsponse = ClientRequestMessageParser.parseValidationRequest(msg);
                            UID = Integer.parseInt(UIDREsponse.getMsgBody());
                            msg = ConnectionToServer.this.in.readMessage();
                        }
                        if (msg != null) {
                            responseMessageType = ConnectionToServer.this.getMessageType(msg);
                            ConnectionToServer.this.serviceMessageQueue.offer(new ServiceMessage(System.currentTimeMillis()));
                            switch (responseMessageType) {
                                case TEST_REQUEST: {
                                    TestRequest testRequest = ServerResponseMessageParser.parseTestRequest(msg);
                                    ConnectionToServer.this.sendHeartbeat(testRequest.getTestReqID());
                                    break;
                                }
                                case HEARTBEAT: {
                                    break;
                                }
                                case LOGON: {
                                    ConnectionToServer.this.isLoggedOn = true;
                                    ((LinkedBlockingDeque)ConnectionToServer.this.clientMessageQueue.get(0)).offer(new ClientMessage(msg));
                                    break;
                                }
                                case LOGOUT: {
                                    ConnectionToServer.this.isLoggedOn = false;
                                    ((LinkedBlockingDeque)ConnectionToServer.this.clientMessageQueue.get(0)).offer(new ClientMessage(msg));
                                    break;
                                }
                                case REJECT: {
                                    if (!ConnectionToServer.this.clientMessageQueue.containsKey(UID)) break;
                                    ((LinkedBlockingDeque)ConnectionToServer.this.clientMessageQueue.get(UID)).offer(new ClientMessage(msg, true, false));
                                    break;
                                }
                                default: {
                                    ((LinkedBlockingDeque)ConnectionToServer.this.clientMessageQueue.get(UID)).offer(new ClientMessage(msg));
                                }
                            }
                            if (!ConnectionToServer.this.isMessageLoggingEnabled) continue;
                            System.out.println("Recieved message: " + msg.toString());
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (FastException e) {
                ConnectionToServer.this.setConnectionBreak("FastException");
            }
            catch (Exception e) {
                ConnectionToServer.this.setConnectionBreak("InboundMessageWorker exception");
            }
        }
    }
}

