/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.multicast;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.openfast.session.Connection;
import org.openfast.session.ConnectionListener;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;

public abstract class MulticastEndpoint
implements Endpoint {
    protected int port;
    protected String group;
    protected String ifaddr;

    public MulticastEndpoint(int port, String group) {
        this(port, group, null);
    }

    public MulticastEndpoint(int port, String group, String ifaddr) {
        this.port = port;
        this.group = group;
        this.ifaddr = ifaddr;
    }

    protected MulticastSocket createSocket() throws FastConnectionException {
        try {
            MulticastSocket socket = new MulticastSocket(new InetSocketAddress(this.group, this.port));
            if (this.ifaddr != null) {
                try {
                    socket.setInterface(InetAddress.getByName(this.ifaddr));
                }
                catch (SocketException e) {
                    throw new FastConnectionException(e);
                }
            }
            return socket;
        }
        catch (IOException e) {
            throw new FastConnectionException(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + "group=" + this.group + "," + "port=" + this.port + "," + "ifaddr=" + this.ifaddr + "]";
    }

    public abstract Connection connect() throws FastConnectionException;

    public void accept() throws FastConnectionException {
    }

    public void setConnectionListener(ConnectionListener listener) {
    }

    public void close() {
    }
}

