% Generated by roxygen2 (4.0.1): do not edit by hand
\name{centroid.sectors}
\alias{centroid.sectors}
\title{Multiple Sectors Centroid}
\usage{
centroid.sectors(sectors, simulations = 1000)
}
\arguments{
\item{sectors}{a list where each list element contains the order of each
asset in the given sector}

\item{simulations}{number of simulations}
}
\value{
the centroid vector
}
\description{
Compute the centroid for expressing views on the relative ranking of assets
within sectors.
}
\examples{
# Express a view on the assets in two sectors
# Sector 1 View: R_2 < R_1 < R_3
# Sector 2 View: R_5 < R_4
x <- list()
x[[1]] <- c(2, 1, 3)
x[[2]] <- c(5, 4)
centroid.sectors(x)
}
\author{
Ross Bennett
}

