% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_efficiency_of_windows.R
\name{plot_efficiency_of_windows}
\alias{plot_efficiency_of_windows}
\title{Plot the efficiency of windows}
\usage{
plot_efficiency_of_windows(poped.db, xt_windows = NULL,
  xt_plus = xt_windows, xt_minus = xt_windows, iNumSimulations = 100,
  y_eff = TRUE, y_rse = TRUE,
  ofv_calc_type = poped.db$settings$ofv_calc_type, mean_line = TRUE,
  mean_color = "red", deviate_by_id = FALSE, ...)
}
\arguments{
\item{poped.db}{A poped database}

\item{xt_windows}{The distance on one direction from the optimal sample 
times.  Can be a number or a matrix of the same size as the xt matrix found
in \code{poped.db$design$xt}.}

\item{xt_plus}{The upper distance from the optimal sample times (xt + 
xt_plus). Can be a number or a matrix of the same size as the xt matrix 
found in \code{poped.db$design$xt}.}

\item{xt_minus}{The lower distance from the optimal sample times (xt - 
xt_minus). Can be a number or a matrix of the same size as the xt matrix 
found in \code{poped.db$design$xt}.}

\item{iNumSimulations}{The number of design simulations to make within the 
specified windows.}

\item{y_eff}{Should one of the plots created have efficiency on the y-axis?}

\item{y_rse}{Should created plots include the relative standard error of each
parameter as a value on the y-axis?}

\item{ofv_calc_type}{OFV calculation type for FIM 
\itemize{ 
\item 1 = "D-optimality". Determinant of the FIM: det(FIM)
\item 2 = "A-optimality".  Inverse of the sum of the expected parameter variances: 
1/trace_matrix(inv(FIM)) 
\item 4 = "lnD-optimality".  Natural logarithm of the determinant of the FIM: log(det(FIM)) 
\item 6 = "Ds-optimality". Ratio of the Determinant of the FIM and the Determinant of the uninteresting
rows and columns of the FIM: det(FIM)/det(FIM_u)
\item 7 = Inverse of the sum of the expected parameter RSE: 1/sum(get_rse(FIM,poped.db,use_percent=FALSE))
}}

\item{mean_line}{Should a mean value line be created?}

\item{mean_color}{The color of the mean value line.}

\item{deviate_by_id}{Should the computations look at deviations per
individual instead of per group?}

\item{...}{Extra arguments passed to \code{evaluate.fim}}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Function plots the efficiency of windows around the optimal design points. 
The function samples from a uniform distribution around the optimal design 
points for each group (or each individual with \code{deviate_by_id=TRUE}, 
with slower calculation times) and compares the results with the optimal 
design. The maximal and minimal allowed values for all design variables as 
defined in poped.db are respected (e.g. poped.db$design_space$minxt and 
poped.db$design_space$maxxt).
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin example)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=0.01,
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70)

############# END ###################
## Create PopED database
## (warfarin example)
#####################################


# Examine efficiency of sampling windows
plot_efficiency_of_windows(poped.db,xt_windows=0.5)

plot_efficiency_of_windows(poped.db,
                           xt_plus=c( 0.5,1,2,1,2,3,7,1),
                           xt_minus=c( 0.1,2,5,4,2,3,6,2))

\dontrun{  
  
  plot_efficiency_of_windows(poped.db,xt_windows=c( 0.5,1,2,1,2,3,7,1))
  
  
  plot_efficiency_of_windows(poped.db,
                             xt_plus=c( 0.5,1,2,1,2,3,7,1),
                             xt_minus=c( 0.1,2,5,4,2,3,6,2),
                             y_rse=FALSE)
  
  plot_efficiency_of_windows(poped.db,
                             xt_plus=c( 0.5,1,2,1,2,3,7,1),
                             xt_minus=c( 0.1,2,5,4,2,3,6,2),
                             y_eff=FALSE)
}

}
\seealso{
Other evaluate_design: \code{\link{evaluate.fim}},
  \code{\link{evaluate_design}}, \code{\link{get_rse}},
  \code{\link{model_prediction}},
  \code{\link{plot_model_prediction}}

Other Graphics: \code{\link{plot_model_prediction}}

Other Simulation: \code{\link{model_prediction}},
  \code{\link{plot_model_prediction}}
}

