% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_design.R
\name{one_design}
\alias{one_design}
\title{Calculate other design parameters of a two-period multi-arm platform design given updated sample sizes}
\usage{
one_design(n2, n0_2, nt, K, M, fwer, marginal.power, delta, seed = 123)
}
\arguments{
\item{n2}{a positive integer, which is the sample size in each of the K+M experimental arms in the second period, n2 > nt}

\item{n0_2}{a positive integer, which is the sample size of the concurrent control for each of the K+M experimental arms in the in the second period}

\item{nt}{a positive integer, the number of patients already enrolled on each of the K experimental arms in the first period when the new arms are added}

\item{K}{a positive integer, the number of experimental arms in the  first period in a two-period K+M trial}

\item{M}{a positive integer, the number of delayed (newly added) experimental arms added in the second period}

\item{fwer}{the family-wise error rate (FWER) to be controlled, default to be the same
throughout the trial}

\item{marginal.power}{the marginal power to achieve in the first period in a two-period
K+M trial}

\item{delta}{the standardized clinical effect size expected to be detected in
the trial}

\item{seed}{an integer for random number generation for numerically evaluating integration, default = 123}
}
\value{
\bold{designs} contains the calculated design parameters for period 1 and 2 including:

\verb{    }\emph{n1} and \emph{n0_1}, the sample sizes of each of the K experimental arms and the
control arm, respectively, in the first period

\verb{    }\emph{n2} and \emph{n0_2}, the updated sample sizes of each of the K + M experimental arms and
its corresponding concurrent control, respectively, after adding M experimental arms in the second period

\verb{    }\emph{nt} and \emph{n0t}, the number of patients already enrolled on each of the K
experimental arms and the control arm, respectively, in the first period when the new
arms are added

\verb{    }\emph{nc}, the updated total sample size of the control arm after adding M
experimental arms in the second period, i.e., the sum of concurrent (n0_2) and nonconcurrent
(n0t) controls

\verb{    }\emph{N2}, the total sample size of the two-period K+M experimental arm (and 1 control
arm) platform trial

\verb{    }\emph{A1},  the allocation ratio (control to experimental arm) before the M new
experimental arms are added and after the initial K experimental arms end

\verb{    }\emph{A2},  the allocation ratio after the M new experimental arms are added and before
the initial K experimental arms end

\verb{    }\emph{cor1}, the correlation of Z statistics between any two of the K initially opened
experimental arms (or between any two of the M delayed arms)

\verb{    }\emph{cor2}, the correlation of Z statistics between any pair of one initially opened
and one delayed experimental arm

\verb{    }\emph{critical_value1}, the critical value for the comparison between any of the K
experimental arms in the first period and the corresponding control

\verb{    }\emph{critical_value2}, the critical value for the comparison between any of the K + M
experimental arms in the second period and the corresponding control

\verb{    }\emph{marginal.power1} and \emph{marginal.power2}, the marginal power for the first
and second period, respectively

\verb{    }\emph{disjunctive.power1} and \emph{disjunctive.power2}, the disjunctive power for the
first and second period, respectively

\verb{    }\emph{effect_size}, the standardized clinical effect size
expected to be detected in the trial
}
\description{
Provide other design parameters for a two-period K+M trial, given n2 and n0_2, nt, K, M, fwer and marginal
power (of the the first period). This function serves for the purpose of spot-testing for any
pre-specified {n, n0_2} pair. Please use \emph{platform_design()} for finding optimal values of n and n0_2.
}
\details{
Given n2 and n0_2, nt, K, M, fwer and marginal power (of the first period), provide other design
parameters for a two-period K+M trial.
}
\examples{
one_design(n2 = 107, n0_2 = 198, nt = 30, K = 2, M = 2, fwer = 0.025,
           marginal.power = 0.8, delta = 0.4)

#$n1
#[1] 101

#$n0_1
#[1] 143

#$n2
#[1] 107

#$n0_2
#[1] 198

#$nt
#[1] 30

#$n0t
#[1] 43

#$nc
#[1] 241

#$N2
#[1] 669

#$A1
#[1] 1.414214

#$A2
#[1] 2.012987

#$cor1
#[1] 0.3508197

#$cor2
#[1] 0.2746316

#$critical_value1
#[1] 2.220604

#$critical_value2
#[1] 2.475233

#$marginal.power1
#[1] 0.8

#$marginal.power2
#[1] 0.80011

#$disjunctive.power1
#[1] 0.9222971

#$disjunctive.power2
#[1] 0.9853799

#$effect_size
#[1] 0.4

}
\references{
\verb{    }Pan, H., Yuan, X. and Ye, J. (2022). An optimal two-period multi-arm confirmatory platform design
with adding new arms. Manuscript submitted for publication.

\verb{    }Dunnett, C. W. (1955). A multiple comparison procedure for comparing
several treatments with a control. Journal of the American Statistical
Association, 50(272), 1096-1121.
}
\author{
\verb{    }Xiaomeng Yuan, Haitao Pan
}
