% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marking.R
\name{marking}
\alias{marking}
\title{Marking Data with Wearing Tags}
\usage{
marking(dataset, frame, cts = getOption("pa.cts"), streamFrame = NULL,
  allowanceFrame = 2, newcolname = "wearing")
}
\arguments{
\item{dataset}{The source dataset, in dataframe format, which needs to be
marked.}

\item{frame}{The size of time interval to be considered.}

\item{cts}{The name of the counts column. The default is "axis1".}

\item{streamFrame}{The size of time interval that the program will look back
or forward if activity is detected. The default is the half of frame.}

\item{allowanceFrame}{The size of time interval that zero counts allowed.
The default is 2.}

\item{newcolname}{The wearing marking column name.  The default is "wearing".
After the data is processed, a new field will be added to the original
dataframe.  This new field is the wearing /nowwearing indicator.}
}
\value{
A dataframe with an extra wearing/non-wearing marking column.
}
\description{
This function marks the dataset with wearing/non-wearing tags.
}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\author{
Zhouwen Liu \email{zhouwen.liu@vumc.org}
}
\keyword{internal}
