% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msharpeTesting.R
\name{msharpeTesting}
\alias{msharpeTesting}
\title{Testing the difference of modified Sharpe ratios}
\usage{
msharpeTesting(x, y, level = 0.9, na.neg = TRUE, control = list())
}
\arguments{
\item{x}{Vector (of lenght \eqn{T}) of returns for the first fund. \code{NA}
values are allowed.}

\item{y}{Vector (of lenght \eqn{T}) of returns for the second fund. \code{NA}
values are allowed.}

\item{level}{Modified Value-at-Risk level. Default: \code{level = 0.90}.}

\item{na.neg}{A logical value indicating whether \code{NA} values should be
returned if a negative modified Value-at-Risk is obtained.  Default
\code{na.neg = TRUE}.}

\item{control}{Control parameters (see *Details*).}
}
\value{
A list with the following components:\cr

\code{n}: Number of non-\code{NA} concordant observations.\cr

\code{msharpe}: Vector (of length 2) of unconditional modified Sharpe
ratios.\cr

\code{dmsharpe}: Modified Sharpe ratios difference.\cr

\code{tstat}: t-stat of modified Sharpe ratios differences.\cr

\code{pval}: pvalues of test of modified Sharpe ratios differences.
}
\description{
Function which performs the testing of the difference of modified Sharpe
ratios.
}
\details{
The modified Sharpe ratio (Favre and Galeano 2002) is one industry
standard for measuring the absolute risk adjusted performance of hedge
funds. This function performs the testing of modified Sharpe ratio
difference for two funds using a similar approach than Ledoit and Wolf
(2002). See also Gregoriou and Gueyie (2003).

For the testing, only the intersection of non-\code{NA} observations for the
two funds are used.

The argument \code{control} is a list that can supply any of the following
components:
\itemize{ 
\item \code{'type'} Asymptotic approach (\code{type = 1}) or
studentized circular bootstrap approach (\code{type = 2}). Default:
\code{type = 1}. 
\item \code{'ttype'} Test based on ratio (\code{type = 1})
or product (\code{type = 2}). Default: \code{type = 2}.
\item \code{'hac'} Heteroscedastic-autocorrelation consistent standard
errors. Default: \code{hac = FALSE}. 
\item \code{'minObs'} Minimum number of concordant observations to compute the ratios. Default: \code{minObs =
10}. 
\item \code{'nBoot'} Number of boostrap replications for computing the
p-value. Default: \code{nBoot = 499}.
\item \code{'bBoot'} Block length in
the circular bootstrap. Default: \code{bBoot = 1}, i.e. iid bootstrap.
\code{bBoot = 0} uses optimal block-length.
\item \code{'pBoot'} Symmetric
p-value (\code{pBoot = 1}) or asymmetric p-value (\code{pBoot = 2}).
Default: \code{pBoot = 1}.
}
}
\note{
Further details on the methdology with an application to the hedge
fund industry is given in Ardia and Boudt (2016). 

Some internal functions where adapted from Michael Wolf MATLAB code.
}
\examples{
## Load the data (randomized data of monthly hedge fund returns)
data("hfdata")
x = hfdata[,1]
y = hfdata[,2]

## Run modified Sharpe testing (asymptotic)
ctr = list(type = 1)
out = msharpeTesting(x, y, level = 0.95, control = ctr)
print(out)

## Run modified Sharpe testing (asymptotic hac)
ctr = list(type = 1, hac = TRUE)
out = msharpeTesting(x, y, level = 0.95, control = ctr)
print(out)
  
## Run modified Sharpe testing (iid bootstrap)
set.seed(1234)
ctr = list(type = 2, nBoot = 250)
out = msharpeTesting(x, y, level = 0.95, control = ctr)
print(out)

## Run modified Sharpe testing (circular bootstrap)
set.seed(1234)
ctr = list(type = 2, nBoot = 250, bBoot = 5)
out = msharpeTesting(x, y, level = 0.95, control = ctr)
print(out)
}
\author{
David Ardia and Kris Boudt.
}
\references{
Ardia, D., Boudt, K. (2015).  
Testing equality of modified Sharpe ratios.
\emph{Finance Research Letters} \bold{13}, pp.97--104. 
\doi{10.1016/j.frl.2015.02.008}

Ardia, D., Boudt, K. (2016).  
The Peer Ratios Performance of Hedge Funds. 
\emph{Working paper}.
\doi{10.2139/ssrn.2000901}

Barras, L., Scaillet, O., Wermers, R. (2010).  
False discoveries in mutual fund performance: Measuring luck in estimated alphas.  
\emph{Journal of Finance} \bold{65}(1), pp.179--216.
\doi{10.1111/j.1540-6261.2009.01527.x}

Favre, L., Galeano, J.A. (2002).  
Mean-modified Value-at-Risk Optimization with Hedge Funds.  
\emph{Journal of Alternative Investments} \bold{5}(2), pp.21--25.
\doi{10.3905/jai.2002.319052}

Gregoriou, G. N., Gueyie, J.-P. (2003).  
Risk-adjusted performance of funds of hedge funds using a modified Sharpe ratio.  
\emph{Journal of Wealth Management} \bold{6}(3), pp.77--83.

Ledoit, O., Wolf, M. (2008). 
Robust performance hypothesis testing with the Sharpe ratio.  
\emph{Journal of Empirical Finance} \bold{15}(5), pp.850--859.
\doi{10.1016/j.jempfin.2008.03.002}

Storey, J. (2002).  
A direct approach to false discovery rates.
\emph{Journal of the Royal Statistical Society B} \bold{64}(3), pp.479--498.
\doi{10.1111/1467-9868.00346}
}
\seealso{
\code{\link{msharpe}}, \code{\link{msharpeScreening}} and
\code{\link{sharpeTesting}}.
}
\keyword{htest}

