% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseLargeScaleCharacteristics.R
\name{summariseLargeScaleCharacteristics}
\alias{summariseLargeScaleCharacteristics}
\title{This function is used to summarise the large scale characteristics of a
cohort table}
\usage{
summariseLargeScaleCharacteristics(
  cohort,
  strata = list(),
  window = list(c(-Inf, -366), c(-365, -31), c(-30, -1), c(0, 0), c(1, 30), c(31, 365),
    c(366, Inf)),
  eventInWindow = NULL,
  episodeInWindow = NULL,
  includeSource = FALSE,
  minCellCount = 5,
  minimumFrequency = 0.005,
  cdm = attr(cohort, "cdm_reference")
)
}
\arguments{
\item{cohort}{The cohort to characterise.}

\item{strata}{Stratification list.}

\item{window}{Temporal windows that we want to characterize.}

\item{eventInWindow}{Tables to characterise the events in the window.}

\item{episodeInWindow}{Tables to characterise the episodes in the window.}

\item{includeSource}{Whether to include source concepts.}

\item{minCellCount}{All counts lower than minCellCount will be obscured.}

\item{minimumFrequency}{Minimum frequency covariates to report.}

\item{cdm}{A cdm reference.}
}
\value{
The output of this function is a `ResultSummary` containing the
relevant information.
}
\description{
This function is used to summarise the large scale characteristics of a
cohort table
}
