% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCategories.R
\name{addCategories}
\alias{addCategories}
\title{Categorize a numeric variable}
\usage{
addCategories(
  x,
  cdm,
  variable,
  categories,
  missingCategoryValue = "None",
  overlap = FALSE,
  tablePrefix = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm}

\item{cdm}{Object that contains a cdm reference. Use CDMConnector to obtain a
cdm reference.}

\item{variable}{Target variable that we want to categorize.}

\item{categories}{List of lists of named categories with lower and upper
limit.}

\item{missingCategoryValue}{Value to assign to those individuals not in
any named category. If NULL or NA, missing will values will be
given.}

\item{overlap}{TRUE if the categories given overlap}

\item{tablePrefix}{The stem for the permanent tables that will be created. If
NULL, temporary tables will be used throughout.}
}
\value{
tibble with the categorical variable added.
}
\description{
Categorize a numeric variable
}
\examples{
#'
\donttest{
library(DBI)
library(duckdb)
library(PatientProfiles)
cohort1 <- dplyr::tibble(
  cohort_definition_id = c("1", "1", "1"),
  subject_id = c("1", "2", "3"),
  cohort_start_date = c(
    as.Date("2010-03-03"), as.Date("2010-03-01"), as.Date("2010-02-01")
  ),
  cohort_end_date = c(
    as.Date("2015-01-01"), as.Date("2013-01-01"), as.Date("2013-01-01")
  )
)

person <- dplyr::tibble(
  person_id = c("1", "2", "3"),
  gender_concept_id = c("8507", "8507", "8507"),
  year_of_birth = c(1980, 1970, 2000),
  month_of_birth = c(03, 07, NA),
  day_of_birth = c(NA, 02, 01)
)

cdm <- mockPatientProfiles(person = person, cohort1 = cohort1)

result <- cdm$cohort1 \%>\%
  addAge(cdm) \%>\%
  addCategories(
    variable = "age",
    categories = list("age_group" = list(
      "0 to 39" = c(0, 39), "40 to 79" = c(40, 79), "80 to 150" = c(80, 150)
    ))
  )
}
}
