% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPPModel.R
\name{is.valid.PPP_Model}
\alias{is.valid.PPP_Model}
\title{Check if an object is a valid PPP_Model}
\usage{
is.valid.PPP_Model(x, comment = FALSE)
}
\arguments{
\item{x}{Object to be checked.}

\item{comment}{If FALSE then the function returns a boolean indicating whether \code{x} is a valid PPP_Model. If TRUE then the function returns a comment instead.}
}
\description{
Checks if an object is a PPP_Model object and whether it is valid for the use in functions like \code{PPP_Model_Exp_Layer_Loss}
}
\examples{
PPPM <- PPP_Model(2, c(1000,2000), c(1,2), dispersion = 2)
PPPM
is.valid.PPP_Model(PPPM)
is.valid.PPP_Model(PPPM, comment = TRUE)

PPPM$alpha <- 2
is.valid.PPP_Model(PPPM)
is.valid.PPP_Model(PPPM, comment = TRUE)

}
