% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_load.R
\name{airsis_load}
\alias{airsis_load}
\title{Load Processed AIRSIS Monitoring Data}
\usage{
airsis_load(year = 2017,
  baseUrl = "https://haze.airfire.org/monitoring/AIRSIS/RData/")
}
\arguments{
\item{year}{desired year (integer or character representing YYYY)}

\item{baseUrl}{base URL for AIRSIS meta and data files}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Loads pre-generated .RData files containing AIRSIS PM2.5 data.

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/AIRSIS/RData/}{https://haze.airfire.org/monitoring/AIRSIS/RData/}
}
\examples{
\dontrun{
airsis <- airsis_load(2017)
airsis_conus <- monitor_subset(airsis, stateCodes=CONUS)
monitorLeaflet(airsis_conus)
}
}
\seealso{
\code{\link{airsis_loadDaily}}

\code{\link{airsis_loadLatest}}
}
\keyword{AIRSIS}
