% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_combine.R
\name{monitor_combine}
\alias{monitor_combine}
\title{Combine List of ws_monitor Objects into Single ws_monitor Object}
\usage{
monitor_combine(monitorList)
}
\arguments{
\item{monitorList}{list containing \emph{ws_monitor} objects}
}
\value{
A emph{ws_monitor} object combining all monitoring data from \code{monitorList}.
}
\description{
Combines a list of \emph{ws_monitor} objects into a single \emph{ws_monitor} object 
by merging the \code{meta} and \code{data} dataframes from each object in \code{monitorList}.
}
\examples{
\dontrun{
monitorList <- list()
monitorList[[1]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1031')
monitorList[[2]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1032')
monitorList[[3]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1033')
monitorList[[4]] <- airsis_createMonitorObject(20160701, 20161231, 'USFS', '1034')
ws_monitor <- monitor_combine(monitorList)
monitorLeaflet(ws_monitor)
} 
}
\keyword{ws_monitor}

