% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_feature_correction.R
\name{plr_decomposition}
\alias{plr_decomposition}
\title{Decompose Seasonality from Data}
\usage{
plr_decomposition(
  data,
  freq,
  power_var,
  time_var,
  plot = FALSE,
  plot_file = NULL,
  title = NULL,
  data_file = NULL
)
}
\arguments{
\item{data}{a dataframe containing PV data that has undergone a power
predictive model, e.g. \code{\link{plr_xbx_model}}.}

\item{freq}{the frequency of seasonality. This is typically 4 but depends
on the location of the system.}

\item{power_var}{name of the power variable, e.g. iacp}

\item{time_var}{name of the time variable, e.g. tvar}

\item{plot}{boolean indicating if you wish to save a plot.}

\item{plot_file}{location to save the plot, if the plot param is given TRUE.}

\item{title}{the title of the plot created if the plot param is given TRUE.}

\item{data_file}{location to save data. Currently non-functional.}
}
\value{
Dataframe containing decomposed time series features
}
\description{
Decomposes seasonality from a dataframe that has already
passed through a PLR Determination test, e.g. \code{\link{plr_xbx_model}}. This method has
the option of creating plot and data files.
}
\examples{
#' # build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
# Perform power modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)
                                  
test_xbx_wbw_decomp <- plr_decomposition(test_xbx_wbw_res, freq = 4,
                                         power_var = 'power_var', time_var = 'time_var',
                                         plot = FALSE, plot_file = NULL, title = NULL, 
                                         data_file = NULL)

}
