% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{plr_build_var_list}
\alias{plr_build_var_list}
\title{Build a Custom Variable List}
\usage{
plr_build_var_list(time_var, power_var, irrad_var, temp_var, wind_var)
}
\arguments{
\item{time_var}{The variable representing time. Typically, a timestamp.}

\item{power_var}{The variable representing time. Typically, in watts.}

\item{irrad_var}{The variable representing irradiance. Typically, either poa or
ghi irradiance.}

\item{temp_var}{The variable representing temperature. Package functions assume 
Celcius.}

\item{wind_var}{optional; The variable representing wind speed.}
}
\value{
Returns dataframe of variable names for the given photovoltaic data for use with later functions
}
\description{
The default var_list generator, plr_variable_check, assumes data comes from
SDLE's sources. If you are using this package with your own data, the format
may not line up appropriately. Use this function to create a variable list to
be passed to other functions so they can keep track of what column names mean.
}
\examples{
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)

}
