% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richie.R
\name{richie}
\alias{richie}
\title{Non-Linear Ritchie's Equation}
\usage{
richie(t, qt, qe, n)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qe}{the numerical value for the amount adsorbed at equilibrium. If this parameter is not defined, it will be estimated.}

\item{n}{the Richie's equation order of reaction. If the parameter value n=1, the function will proceed to first-order Richie's equation. If the value n=2, the function will proceed to second-order Richie's equation, and if the n is not defined, the value of n will be estimated.}
}
\value{
the non-linear regression and the parameters estimation for the Richie adsorption kinetic model
}
\description{
The Ritchie's Equation is a well-known empirical rate equation for gas particle adsorption on solid surfaces. Assuming that the rate of adsorption is exclusively determined by the percentage of vacant sites at time t (Kaki, Gögsu, Altindal, Salih, and Bekaroglu, 2020).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.68
richie(t,qt,qe)
richie(t,qt,n=3)}
}
\references{
Ritchie, A. G. (1977) <doi:10.1039/F19777301650> Alternative to the Elovich equation for the kinetics of adsorption of gases on solids. Journal of the Chemical Society, Faraday Transactions 1: Physical Chemistry in Condensed Phases, 73, 1650-1653.

Kaki, E., Gögsu, N., Altindal, A., Salih, B., &; Bekaroglu, Ö. (2020) <doi:10.1142/S1088424619500196> Synthesis, characterization and VOCs adsorption kinetics of diethylstilbestrol-substituted metallophthalocyanines. In Porphyrin Science By Women (In 3 Volumes) (pp. 991-999). World Scientific Publishing Co.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
