% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfo.lm.r
\name{pfo.lm}
\alias{pfo.lm}
\title{Linear Pseudo-First-Order Adsorption Kinetic Model}
\usage{
pfo.lm(t, qt, qe)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t. This parameter should not be greater than or equal to qe as it will cause an incalculable value. Any row(s) that contain(s) a value greater than or equal to qe will be automatically removed to proceed with the calculation.}

\item{qe}{the numerical value for the amount adsorbed at equilibrium}
}
\value{
the linear regression and the parameter estimation for the Pseudo First Order Model
}
\description{
The Pseudo-First-Order Adsorption Kinetic Model follows the Linear Driving Force model (LDF) which states that the rate of mass transfer is equal to the transfer coefficient and the difference between the amount adsorbed and the amount adsorbed in equilibrium. This model is an empirical rate equation known to describe the rate of sorption in liquid-phase systems. The PFO model is not suitable for the whole adsorption reaction since the rate of adsorption decreases until it reaches the maximum adsorption capacity, and thus, the rate is zero at equilibrium (Plazinski, Rudzinski, and Plazinska, 2009).
}
\examples{
t <- c(0,15,30,45,60,75,90,105,120)
qt <-c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.8
pfo.lm(t,qt,qe)
}
\references{
Lagergren, S. (1898), Zur theorie der sogenannten adsorption gelster stoffe, Kungliga Svenska Vetenskapsakademiens. Handlingar, 24 (4) : 1-39.

Plazinski, W., Rudzinski, W., &; Plazinska, A. (2009) <doi:10.1016/j.cis.2009.07.009> Theoretical models of sorption kinetics including a surface reaction mechanism: A review. In Advances in Colloid and Interface Science</i> (Vol. 152, Issues 1-2, pp. 2-13).
}
\author{
Jeff Ryan S. Magalong

Joshua Z. Dela Cruz

Jeann M. Bumatay

Chester C. Deocaris
}
