% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maw.R
\name{maw}
\alias{maw}
\title{Non-Linear Matthews and Weber Diffusion Model}
\usage{
maw(t, Ct, Co)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{Ct}{the numerical value for the concentration of the adsorbent at time t}

\item{Co}{the numerical value for the initial concentration of the adsorbent. If this parameter is not defined, it will be estimated.}
}
\value{
the non-linear regression and the parameter estimation for the Matthews and Weber diffusion model
}
\description{
The Matthews and Weber Diffusion Model is used in determining the rate constant for film diffusion where it assumes that intraparticle diffusion can be neglected at the early period of contact. Derived from Fickien’s law application, the solute concentration in the liquid phase in this model is expressed as a function of solute concentration difference in the liquid phase and at the adsorbent surface (Prasad & Srivastava, 2009).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
Ct <- c(10.000,8.141,8.056,7.949,7.863,7.799,7.778,7.756,7.692)
Co <- 10
maw(t,Ct,Co)}
}
\references{
Mathews, A. P., &; Weber, W. J. (1984) <doi:10.1080/00986448408940104> Modeling and parameter evaluation for adsorption in slurry reactors. Chemical Engineering Communications, 25(1-6), 157-171.

Krishna Prasad, R., & Srivastava, S. N. (2009) <doi:10.1016/j.cej.2008.05.021> Sorption of distillery spent wash onto fly ash: Kinetics and mass transfer studies. Chemical Engineering Journal, 146(1), 90–97.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
