% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{assignBlocks}
\alias{assignBlocks}
\title{Assign set numbers to a vector of values.}
\usage{
assignBlocks(values, set_size = 5, sort_values = TRUE)
}
\arguments{
\item{values}{Vector of values}

\item{set_size}{Number of distinct values allowed in a set}

\item{sort_values}{Before assigning values to sets, sort the values?}
}
\value{
Vector (same length as input) with set numbers
}
\description{
Each set has size set_size (internally optimized using \code{\link{correctSetSize}}), holding values from 'values'.
This gives n such sets and the return value is just the set index for each value.
}
\examples{
 #library(PTXQC)
 assignBlocks(c(1:11, 1), set_size = 3, sort_values = FALSE)
 ## --> 1 1 1 2 2 2 3 3 3 4 4 1
 
}

