% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PSAboot}
\alias{PSAboot}
\title{Bootstraping for propensity score analysis}
\usage{
PSAboot(Tr, Y, X, M = 100, formu = as.formula(paste0("treat ~ ",
  paste0(names(X), collapse = " + "))), control.ratio = 5,
  control.sample.size = min(control.ratio * min(table(Tr)), max(table(Tr))),
  control.replace = TRUE, treated.sample.size = min(table(Tr)),
  treated.replace = TRUE, methods = getPSAbootMethods(), parallel = TRUE,
  seed = NULL, ...)
}
\arguments{
\item{Tr}{numeric (0 or 1) or logical vector of treatment indicators.}

\item{Y}{vector of outcome varaible.}

\item{X}{matrix or data frame of covariates used to estimate the propensity scores.}

\item{M}{number of bootstrap samples to generate.}

\item{formu}{formula used for estimating propensity scores. The default is to use
all covariates in \code{X}.}

\item{control.ratio}{the ratio of control units to sample relative to the treatment units.}

\item{control.sample.size}{the size of each bootstrap sample of control units.}

\item{control.replace}{whether to use replacement when sampling from control units.}

\item{treated.sample.size}{the size of each bootstrap sample of treatment units. The
default uses all treatment units for each boostrap sample.}

\item{treated.replace}{whether to use replacement when sampling from treated units.}

\item{methods}{a named vector of functions for each PSA method to use.}

\item{seed}{random seed. Each iteration, i, will use a seed of \code{seed + i}.}

\item{parallel}{whether to run the bootstrap samples in parallel.}

\item{...}{other parameters passed to \code{\link{Match}} and \code{\link{psa.strata}}}
}
\value{
a list with following elements:
		  \describe{
		  \item{overall.summary}{Data frame with the results using the complete
		                         dateset (i.e. unboostrapped results).}
		  \item{overall.details}{Objects returned from each method for complete dataset.}
		  \item{pooled.summary}{Data frame with results of each boostrap sample.}
		  \item{pooled.details}{List of objects returned from each method for each
		        boostrap sample.}
		  \item{control.sample.size}{sample size used for control units.}
		  \item{treated.sample.size}{sample size used for treated units.}
		  \item{control.replace}{whether control units were sampled with replacement.}
		  \item{treated.replace}{whether treated units were sampled with replacement.}
		  \item{Tr}{vector of treatment assignment.}
		  \item{Y}{vector out outcome.}
		  \item{X}{matrix or data frame of covariates.}
		  \item{M}{number of bootstrap samples.}
		  }
}
\description{
Bootstrapping has become a popular resampling method for estimating sampling
distributions. And propensity score analysis (PSA) has become popular for estimating
causal effects in observational studies. This function implements bootstrapping
specifically for PSA. Like typical bootstrapping methods, this function estiamtes
treatment effects for M random samples. However, unlike typical bootstrap methods,
this function allows for separate sample sizes for treatment and control units.
That is, under certain circumstances (e.g. when the ratio of treatment-to-control
units is large) bootstrapping only the control units may be desirable. Additionally,
this function provides a framework to use multiple PSA methods for each bootstrap
sample.
}
\seealso{
getPSAbootMethods
}

