% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagn.R
\name{diagn}
\alias{diagn}
\title{Extract or construct a diagonal matrix.}
\usage{
diagn(x = 1, nrow = length(x), ncol = nrow)
}
\arguments{
\item{x}{a matrix, vector or 1D array, or missing.}

\item{nrow, ncol}{optional dimensions for the result when \code{x} is not a matrix.}
}
\value{
matrix with diagonal elements set to \code{x}
}
\description{
This works like \code{\link{diag}} except when \code{x} is a single
integer value.  If \code{x} is a single integer value then it
assumes that you want a 1 by 1 matrix with the value set to \code{x}
}
\examples{
diag(5)
diagn(5)
}
\seealso{
\code{\link{diag}}
}
\keyword{array}

