% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPtreereg.R
\name{PPTreereg}
\alias{PPTreereg}
\title{Construct the projection pursuit regression tree}
\usage{
PPTreereg(formula,data,DEPTH=NULL,Rr=1,PPmethod="LDA",
                 weight=TRUE,lambda=0.1,r=1,TOL.CV=0.1,selP=NULL,
                 energy=0,maxiter=500,
                 standardized=TRUE,even=TRUE,space=0,
                 maxFinalNode=20,maxNodeN=10,...)
}
\arguments{
\item{formula}{an object of class "formula"}

\item{data}{data frame}

\item{DEPTH}{depth of the projection pursuit regression tree}

\item{Rr}{cutoff rule in each node}

\item{PPmethod}{method for projection pursuit; \code{"LDA"}, \code{"PDA"}, \code{"Lr"},
\code{"GINI"}, and \code{"ENTROPY"}.}

\item{weight}{weight flag in \code{LDA}, \code{PDA} and \code{Lr} index}

\item{lambda}{lambda in PDA index}

\item{r}{r in Lr index}

\item{TOL.CV}{CV limit for the final node}

\item{selP}{number of variables for the final node in Method 5}

\item{energy}{energy parameter}

\item{maxiter}{number of maximum iteration}

\item{standardized}{standardize each X variable before fitting
the tree structure. Default value is TRUE}

\item{even}{divide evenly at each node. Default value is TRUE}

\item{space}{space between two groups of dependent variable}

\item{maxFinalNode}{maximum number of final node}

\item{maxNodeN}{maximum number of observations in the final node}

\item{...}{arguments to be passed to methods}
}
\value{
Tree.result projection pursuit regression tree result with
                    \code{PPtreeclass} object format

MSE mean squared error of the final tree

\code{mean.G}  means of the observations in the final node

\code{sd.G} standard deviations of the observations in the final node.

\code{coef.G} regression coefficients for Method 3, 4 and 5

\code{origY} original dependent variable vector

\code{origX.mean} mean of original X

\code{origX.sd} standard deviation of original X

\code{class.origX.mean} means of the each independent variables in the final node
}
\description{
Find regression tree structure using various projection pursuit indices
in each split.
}
\examples{
data(mtcars)
Tree.result <- PPTreereg(mpg~.,mtcars,DEPTH=2,PPmethod="LDA")
Tree.result

}
\references{
...
}
\keyword{tree}
