% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POUMM.R
\name{simulateTrait}
\alias{simulateTrait}
\title{Simulate a trait on a tree under a ML fit of the POUMM model}
\usage{
simulateTrait(object, tree = NULL)
}
\arguments{
\item{object}{an S3 object of class POUMM}

\item{tree}{a phylo object. If NULL (default) the trait is simulated on the
tree, on which the POUMM object has been fit.}
}
\value{
a numerical vector containing the simulated trait value for each tip 
in the tree.
}
\description{
Use the maximum likelihood parameters of the model to simulate
trait values on a phylogenetic tree.
}
\details{
This function is a shortcut to calling
\code{\link{rVNodesGivenTreePOUMM}}, which will map the inferred parameters 
of the model back to the original POUMM parameters alpha, theta, sigma, sigmae,
and g0.
}
\seealso{
\code{\link{rVNodesGivenTreePOUMM}}
}
