% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeSetRegimes}
\alias{PCMTreeSetRegimes}
\title{Assign regimes on a tree given a set of starting branches}
\usage{
PCMTreeSetRegimes(tree, nodes, regimes = as.integer(1:(length(nodes) +
  1)), inplace = TRUE)
}
\arguments{
\item{tree}{a phylo object}

\item{nodes}{a character vector containing tip or node labels or an integer
vector denoting tip or internal nodes in tree - the regimes change at the
start of the branches leading to these nodes.}

\item{regimes}{an integer or character vector of length equal to
length(nodes) + 1 containing the regime-names to be assigned for each regime.
If NULL the regime names will be the integers 1:(length(nodes) + 1).}

\item{inplace}{a logical indicating if the change should be done to the tree
in the calling environment (TRUE) or a copy of the tree with set edge.regime
member should be returned (FALSE). Default is TRUE.}
}
\value{
If inplace is TRUE nothing, otherwise a copy of the tree with set
edge.regime member.
}
\description{
Assign regimes on a tree given a set of starting branches
}
\details{
It is assumed that each regime "paints" a linked subset of branches
on a tree. Thus, each regime is fully described by its starting branch. The
descendant branches inherit this regime until reaching a tip or a node that is
present in the \code{nodes} parameter.
}
\seealso{
\code{\link{PCMTreeGetStartingNodesRegimes}}
}
