% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeGetStartingNodesRegimes}
\alias{PCMTreeGetStartingNodesRegimes}
\title{Get the starting branch' nodes for each regime on a tree}
\usage{
PCMTreeGetStartingNodesRegimes(tree, preorder = PCMTreePreorder(tree))
}
\arguments{
\item{tree}{a phylo object with an edge.regime member denoting regimes. The
function assumes that each regime covers a linked set of branches on the tree.}

\item{preorder}{an integer vector of row-indices in tree$edge as returned by
\code{\link{PCMTreePreorder}}. Defaults to \code{PCMTreePreorder(tree)}.
Specifying this argument may improve performance if PCMTreePreorder had to be
called earlier.}
}
\value{
an integer with elements equal to the starting nodes for each regime in
\code{regimes}.
}
\description{
Get the starting branch' nodes for each regime on a tree
}
\details{
We call a starting branch the first branch from the root to the tips
with a given regime. A starting node is the node at which a starting branch
ends.
}
\seealso{
\code{\link{PCMTreeSetRegimes}}
}
