% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMSim}
\alias{PCMSim}
\title{Simulation of a phylogenetic comparative model on a tree}
\usage{
PCMSim(tree, model, X0, metaI = PCMInfo(X = NULL, tree = tree, model =
  model, verbose = verbose), verbose = FALSE)
}
\arguments{
\item{tree}{a phylo object specifying a rooted tree.}

\item{model}{an S3 object specifying the model (see Details).}

\item{X0}{a numeric vector of length k (the number of traits) specifying the
trait values at the root of the tree.}

\item{metaI}{a named list containg meta-information about the data and the
model.}

\item{verbose}{a logical indicating if informative messages should be written
during execution.}
}
\value{
numeric M x k matrix of values at all nodes of the tree, i.e. root,
internal and tip, where M is the number of nodes: \code{M=dim(tree$edge)[1]+1},
with indices from 1 to N=length(tree$tip.label) corresponding to tips, N+1
corresponding to the root and bigger than N+1 corresponding to internal nodes.
The function will fail in case that the length of the argument vector X0 differs
from the number of traits specified in \code{metaI$k}. Error message:
"ERR:02002:PCMBase:PCM.R:PCMSim:: X0 must be of length ...".
}
\description{
Generate trait data on a tree according to a multivariate stochastic
model with one or several regimes
}
\details{
Internally, this function uses the \code{\link{PCMCond}} iimplementation
 for the given model class.
}
\seealso{
\code{\link{PCMLik}} \code{\link{PCMInfo}} \code{\link{PCMCond}}
}
