% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_preferences_utils.R
\name{get_proposer_rank}
\alias{get_proposer_rank}
\title{Rank preferences for an arbitrary proposer and rejecter, based on distance
(i.e., difference) between them}
\usage{
get_proposer_rank(proposer, rejecter, window_size)
}
\arguments{
\item{proposer}{A vector containing indices of transitions for the proposing
(optimal) party}

\item{rejecter}{A vector containing indices of transitions for the rejecting
(pessimal) party}

\item{window_size}{The maximum number of indices that are allowed to separate
a predicted and reference transition, before the two are considered
incompatible}
}
\value{
A matrix with \code{length(proposer)} columns and
  \code{length(rejecter)} rows, giving ordered preferences for the proposer,
  based on the absolute difference between the ith proposer index and the
  rejecter indices, where differences larger than \code{window_size} are
  treated as omitted preferences, i.e., non-possibilities.
}
\description{
Rank preferences for an arbitrary proposer and rejecter, based on distance
(i.e., difference) between them
}
\keyword{internal}
