% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_emulation.R
\name{cov_fn}
\alias{cov_fn}
\title{Covariance function for Gaussian process}
\usage{
cov_fn(n, ndash, var_u, k_width)
}
\arguments{
\item{n}{Argument 1: kernel is a function of \code{ndash-n}}

\item{ndash}{Argument 2: kernel is a function of \code{ndash-n}}

\item{var_u}{Global variance}

\item{k_width}{Kernel width}
}
\value{
Covariance value
}
\description{
Radial kernel covariance function for Gaussian process.

Used for a Gaussian process \code{GP(m,k(.,.))}, an instance X of which has covariance k(n,n') between X(n) and X(n').

Covariance function is parametrised by \code{var_u} (general variance) and \code{k_width} (kernel width)
}
\examples{

# We will sample from Gaussian processes
#  GP(0,k(.,.)=cov_fn(.,.;var_u,theta))
# at these values of n
nvals=seq(1,300,length=100)

# We will consider two theta values
kw1=10; kw2=30

# We will consider two var_u values
var1=1; var2=10

# Covariance matrices
cov11=outer(nvals,nvals,function(n,ndash) cov_fn(n,ndash,var_u=var1,
  k_width=kw1))
cov12=outer(nvals,nvals,function(n,ndash) cov_fn(n,ndash,var_u=var1,
  k_width=kw2))
cov21=outer(nvals,nvals,function(n,ndash) cov_fn(n,ndash,var_u=var2,
  k_width=kw1))
cov22=outer(nvals,nvals,function(n,ndash) cov_fn(n,ndash,var_u=var2,
  k_width=kw2))

# Dampen slightly to ensure positive definiteness
damp=1e-5
cov11=(1-damp)*(1-diag(length(nvals)))*cov11 + diag(length(nvals))*cov11
cov12=(1-damp)*(1-diag(length(nvals)))*cov12 + diag(length(nvals))*cov12
cov21=(1-damp)*(1-diag(length(nvals)))*cov21 + diag(length(nvals))*cov21
cov22=(1-damp)*(1-diag(length(nvals)))*cov22 + diag(length(nvals))*cov22

# Sample
set.seed(35243)
y11=rmnorm(1,mean=0,varcov=cov11)
y12=rmnorm(1,mean=0,varcov=cov12)
y21=rmnorm(1,mean=0,varcov=cov21)
y22=rmnorm(1,mean=0,varcov=cov22)

# Plot
rr=max(abs(c(y11,y12,y21,y22)))
plot(0,xlim=range(nvals),ylim=c(-rr,rr+10),xlab="n",
  ylab=expression("GP(0,cov_fn(.,.;var_u,theta))"))
lines(nvals,y11,lty=1,col="black")
lines(nvals,y12,lty=2,col="black")
lines(nvals,y21,lty=1,col="red")
lines(nvals,y22,lty=2,col="red")
legend("topright",c("k_width=10, var_u=1", "k_width=30, var_u=1",
  "k_width=10, var_u=10","k_width=30, var_u=10"),
  lty=c(1,2,1,2),col=c("black","black","red","red"))

}
\keyword{emulation}
