/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BingAerialTileSource
extends AbstractOsmTileSource {
    private static String API_KEY = "Arzdiw4nlOJzRwOz__qailc8NiR31Tt51dN2D7cm57NrnceZnCpgOkmJhNpGoppU";
    private static Future<List<Attribution>> attributions;

    public BingAerialTileSource() {
        super("Bing Aerial Maps", "http://ecn.t2.tiles.virtualearth.net/tiles/");
        if (attributions == null) {
            attributions = Executors.newSingleThreadExecutor().submit(new Callable<List<Attribution>>(){

                @Override
                public List<Attribution> call() throws Exception {
                    return BingAerialTileSource.this.loadAttributionText();
                }
            });
        }
    }

    private List<Attribution> loadAttributionText() {
        try {
            URL uRL = new URL("http://dev.virtualearth.net/REST/v1/Imagery/Metadata/Aerial/0,0?zl=1&mapVersion=v1&key=" + API_KEY + "&include=ImageryProviders&output=xml");
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            AttrHandler attrHandler = new AttrHandler();
            xMLReader.setContentHandler(attrHandler);
            xMLReader.parse(new InputSource(inputStream));
            return attrHandler.attributions;
        }
        catch (IOException iOException) {
            System.err.println("Could not open Bing aerials attribution metadata.");
        }
        catch (SAXException sAXException) {
            System.err.println("Could not parse Bing aerials attribution metadata.");
            sAXException.printStackTrace();
        }
        return null;
    }

    @Override
    public int getMaxZoom() {
        return 22;
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTilePath(int n, int n2, int n3) throws IOException {
        try {
            if (attributions.get() == null) {
                throw new IOException("Cannot load Bing attribution");
            }
            String string = BingAerialTileSource.computeQuadTree(n, n2, n3);
            return "/tiles/a" + string + "." + this.getExtension() + "?g=587";
        }
        catch (Exception exception) {
            throw new IOException("Cannot load Bing attribution", exception);
        }
    }

    @Override
    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    @Override
    public boolean requiresAttribution() {
        return true;
    }

    @Override
    public Image getAttributionImage() {
        try {
            return ImageIO.read(JMapViewer.class.getResourceAsStream("images/bing_maps.png"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getAttributionLinkURL() {
        return "http://go.microsoft.com/?linkid=9710837";
    }

    @Override
    public String getTermsOfUseURL() {
        return "http://opengeodata.org/microsoft-imagery-details";
    }

    @Override
    public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
        try {
            if (!attributions.isDone()) {
                return "Loading Bing attribution data...";
            }
            if (attributions.get() == null) {
                return "Error loading Bing attribution data";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Attribution attribution : attributions.get()) {
                if (n > attribution.maxZoom || n < attribution.minZoom || !(coordinate.getLon() < attribution.max.getLon()) || !(coordinate2.getLon() > attribution.min.getLon()) || !(coordinate.getLat() > attribution.min.getLat()) || !(coordinate2.getLat() < attribution.max.getLat())) continue;
                stringBuilder.append(attribution.attribution);
                stringBuilder.append(" ");
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Error loading Bing attribution data";
        }
    }

    static String computeQuadTree(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i > 0; --i) {
            char c = '0';
            int n4 = 1 << i - 1;
            if ((n2 & n4) != 0) {
                c = (char)(c + 1);
            }
            if ((n3 & n4) != 0) {
                c = (char)(c + 2);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    class AttrHandler
    extends DefaultHandler {
        private String string;
        private Attribution curr;
        private List<Attribution> attributions = new ArrayList<Attribution>();
        private double southLat;
        private double northLat;
        private double eastLon;
        private double westLon;
        private boolean inCoverage = false;

        AttrHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("ImageryProvider".equals(string3)) {
                this.curr = new Attribution();
            } else if ("CoverageArea".equals(string3)) {
                this.inCoverage = true;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.string = new String(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("ImageryProvider".equals(string3)) {
                this.attributions.add(this.curr);
            } else if ("Attribution".equals(string3)) {
                this.curr.attribution = this.string;
            } else if (this.inCoverage && "ZoomMin".equals(string3)) {
                this.curr.minZoom = Integer.parseInt(this.string);
            } else if (this.inCoverage && "ZoomMax".equals(string3)) {
                this.curr.maxZoom = Integer.parseInt(this.string);
            } else if (this.inCoverage && "SouthLatitude".equals(string3)) {
                this.southLat = Double.parseDouble(this.string);
            } else if (this.inCoverage && "NorthLatitude".equals(string3)) {
                this.northLat = Double.parseDouble(this.string);
            } else if (this.inCoverage && "EastLongitude".equals(string3)) {
                this.eastLon = Double.parseDouble(this.string);
            } else if (this.inCoverage && "WestLongitude".equals(string3)) {
                this.westLon = Double.parseDouble(this.string);
            } else if ("BoundingBox".equals(string3)) {
                this.curr.min = new Coordinate(this.southLat, this.westLon);
                this.curr.max = new Coordinate(this.northLat, this.eastLon);
            } else if ("CoverageArea".equals(string3)) {
                this.inCoverage = false;
            }
            this.string = "";
        }
    }

    class Attribution {
        String attribution;
        int minZoom;
        int maxZoom;
        Coordinate min;
        Coordinate max;

        Attribution() {
        }
    }
}

